﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// RawRectangleF 扩展
    /// </summary>
    public static class RawRectangleFExpand
    {
        /// <summary>
        /// 将框剪切至视频帧的范围内
        /// </summary>
        /// <param name="rect">要裁切的区域</param>
        /// <param name="minX">最小X值</param>
        /// <param name="minY">最小Y值</param>
        /// <param name="maxX">最大X值</param>
        /// <param name="maxY">最大Y值</param>
        /// <returns>是否成功裁切</returns>
        public static RawRectangleF ClipInVideoFrame(RawRectangleF rect, float minX, float minY, float maxX, float maxY)
        {
            rect.Left = MathHelper.Clip(minX, maxX, rect.Left);
            rect.Right = MathHelper.Clip(minX, maxX, rect.Right);
            rect.Top = MathHelper.Clip(minY, maxY, rect.Top);
            rect.Bottom = MathHelper.Clip(minY, maxY, rect.Bottom);

            return rect;
        }

        /// <summary>
        /// 区域是否有效
        /// </summary>
        /// <param name="rect">矩形区域</param>
        /// <returns>是否有效</returns>
        public static bool IsEffective(RawRectangleF rect)
        {
            if (rect.Left >= rect.Right || rect.Top >= rect.Bottom)
                return false;

            return true;
        }
    }
}
