﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SharpDX.Mathematics.Interop;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// SharpDX颜色辅助类
    /// </summary>
    public static class SharpDxColorHelper
    {
        /// <summary>
        /// 由RGBG值获取颜色
        /// </summary>
        /// <param name="r">红色值</param>
        /// <param name="g">绿色值</param>
        /// <param name="b">蓝色值</param>
        /// <param name="a">透明度</param>
        /// <returns>颜色</returns>
        public static RawColor4 FromRGBA(float r, float g, float b, float a)
        {
            return new RawColor4(r, g, b, a);
        }

        /// <summary>
        /// 由RGBG值获取颜色
        /// </summary>
        /// <param name="r">红色值</param>
        /// <param name="g">绿色值</param>
        /// <param name="b">蓝色值</param>
        /// <param name="a">透明度</param>
        /// <returns>颜色</returns>
        public static RawColor4 FromRGBA(double r, double g, double b, double a)
        {
            return new RawColor4((float)r, (float)g, (float)b, (float)a);
        }

        /// <summary>
        /// 由RGBG值获取颜色
        /// </summary>
        /// <param name="code">颜色码(#AARRGGBB)，例如：#FFFF0000</param>
        /// <returns>颜色</returns>
        public static RawColor4 FromString(string code)
        {
            RawColor4 result = new RawColor4();

            result.A = Convert.ToInt32(code.Substring(1, 2), 16) / 255f;
            result.R = Convert.ToInt32(code.Substring(3, 2), 16) / 255f;
            result.G = Convert.ToInt32(code.Substring(5, 2), 16) / 255f;
            result.B = Convert.ToInt32(code.Substring(7, 2), 16) / 255f;

            return result;
        }
    }
}
