﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Framework.Domain
{
    /// <summary>
    /// 系统监控模型
    /// </summary>
    public class SystemMonitorModel : ModelBase
    {
        #region CpuUsedPercentage -- CPU 利用率

        private double cpuUsedPercentage;
        /// <summary>
        /// CPU 利用率
        /// </summary>
        public double CpuUsedPercentage
        {
            get { return cpuUsedPercentage; }
            set { cpuUsedPercentage = value; this.RaisePropertyChanged(nameof(CpuUsedPercentage)); }
        }

        #endregion

        #region MemoryUsedPercentage -- 内存利用率

        private double memoryUsedPercentage;
        /// <summary>
        /// 内存利用率
        /// </summary>
        public double MemoryUsedPercentage
        {
            get { return memoryUsedPercentage; }
            set { memoryUsedPercentage = value; this.RaisePropertyChanged(nameof(MemoryUsedPercentage)); }
        }

        #endregion

        #region MemoryUsed -- 内存使用量

        private ulong memoryUsed;
        /// <summary>
        /// 内存使用量
        /// </summary>
        public ulong MemoryUsed
        {
            get { return memoryUsed; }
            set { memoryUsed = value; this.RaisePropertyChanged(nameof(MemoryUsed)); }
        }

        #endregion

        #region MemoryTotal -- 内存总量

        private ulong memoryTotal;
        /// <summary>
        /// 内存总量
        /// </summary>
        public ulong MemoryTotal
        {
            get { return memoryTotal; }
            set { memoryTotal = value; this.RaisePropertyChanged(nameof(MemoryTotal)); }
        }

        #endregion

        #region GpuModels -- GPU模型集合

        private ObservableCollection<SystemMonitorGpuModel> gpuModels = new ObservableCollection<SystemMonitorGpuModel>();
        /// <summary>
        /// GPU模型集合
        /// </summary>
        public ObservableCollection<SystemMonitorGpuModel> GpuModels
        {
            get { return gpuModels; }
            set { gpuModels = value; this.RaisePropertyChanged(nameof(GpuModels)); }
        }

        #endregion
    }
}
