﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using LiteDB;

namespace VIZ.Framework.ImageContrastTool
{
    /// <summary>
    /// LiteDB数据上下文
    /// </summary>
    public class LiteDbContext : IDisposable
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(LiteDbContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public LiteDbContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);

            this.SystemConfigs = this.Database.GetCollection<SystemConfig>();
        }

        // -----------------------------------------------------------------------------------------------------------
        // -- OpenCV -- 
        // -----------------------------------------------------------------------------------------------------------

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }

        /// <summary>
        /// 视频分组
        /// </summary>
        public ILiteCollection<SystemConfig> SystemConfigs { get; private set; }


        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.SystemConfigs = null;

            this.Database?.Dispose();
        }
    }
}
