﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Connection;
using VIZ.Framework.Storage;

namespace VIZ.Framework.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化延时
    /// </summary>
    public class AppSetup_DelayInit : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_DelayInit));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化延时";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ApplicationDomain.DelayManager?.Dispose();
        }

    }
}
