﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using System.Threading;
using VIZ.Framework.Domain;

namespace VIZ.Framework.Module
{
    /// <summary>
    /// 应用程序启动 -- 单例启动
    /// </summary>
    public class AppSetup_Single : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_Single));

        /// <summary>
        /// 
        /// </summary>
        private EventWaitHandle ProgramStarted;

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 单例启动";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            string applicationName = System.Diagnostics.Process.GetCurrentProcess().ProcessName;
            bool createNew;
            this.ProgramStarted = new EventWaitHandle(false, EventResetMode.AutoReset, applicationName, out createNew);
            if (!createNew)
            {
                ProgramStarted.Set();
                return false;
            }

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }
    }
}
