﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Storage
{
    /// <summary>
    /// 视频 配置
    /// </summary>
    public class VideoConfig : IniConfigBase
    {
        /// <summary>
        /// 是否显示FPS （True | Flase）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "Flase", Type = typeof(bool))]
        public string VIDEO_IS_SHOW_FPS { get; set; }

        /// <summary>
        /// 视频渲染等待（单位：毫秒）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "5", Type = typeof(int))]
        public string VIDEO_RENDER_WAIT { get; set; }

        /// <summary>
        /// 视频背景颜色
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FF000000", Type = typeof(RawColor4))]
        public string VIDEO_BACKGROUND_COLOR { get; set; }

        /// <summary>
        /// 跟踪框边框宽度（单位：像素）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "2", Type = typeof(int))]
        public string VIDEO_TRACKING_BOX_BORDER_WIDTH { get; set; }

        /// <summary>
        /// 跟踪框边框颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FFFF0000", Type = typeof(RawColor4))]
        public string VIDEO_TRACKING_BOX_BORDER_COLOR { get; set; }

        /// <summary>
        /// 检测边框宽度（单位：像素）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "2", Type = typeof(int))]
        public string VIDEO_DETECT_BOX_BORDER_WIDTH { get; set; }

        /// <summary>
        /// 检测框边框颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FFFF7373", Type = typeof(RawColor4))]
        public string VIDEO_DETECT_BOX_BORDER_COLOR { get; set; }

        /// <summary>
        /// 框选框边框宽度（单位：像素）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "4", Type = typeof(int))]
        public string VIDEO_SELECTION_BOX_BORDER_WIDTH { get; set; }

        /// <summary>
        /// 框选框边框颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FFFF6D87", Type = typeof(RawColor4))]
        public string VIDEO_SELECTION_BOX_BORDER_COLOR { get; set; }

        /// <summary>
        /// 剪切框宽度（单位：像素）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "810", Type = typeof(int))]
        public string VIDEO_CLIP_BOX_WIDTH { get; set; }

        /// <summary>
        /// 剪切框边框宽度（单位：像素）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "4", Type = typeof(int))]
        public string VIDEO_CLIP_BOX_BORDER_WIDTH { get; set; }

        /// <summary>
        /// 剪切框边框颜色
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FFFF0000", Type = typeof(RawColor4))]
        public string VIDEO_CLIP_BOX_BORDER_COLOR { get; set; }

        /// <summary>
        /// 剪切掩码颜色
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#44000000", Type = typeof(RawColor4))]
        public string VIDEO_CLIP_BOX_MASK_COLOR { get; set; }

        /// <summary>
        /// 剪切框中心轴宽度
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "2", Type = typeof(double))]
        public string VIDEO_CLIP_BOX_CENTER_AXIS_WIDTH { get; set; }

        /// <summary>
        /// 剪切框中心轴颜色
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#FF000000", Type = typeof(RawColor4))]
        public string VIDEO_CLIP_BOX_CENTER_AXIS_COLOR { get; set; }

        /// <summary>
        /// 剪切框中心轴透明度
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "0.4", Type = typeof(double))]
        public string VIDEO_CLIP_BOX_CENTER_AXIS_OPACITY { get; set; }

        /// <summary>
        /// 剪切框自动移动速度（单位：像素/帧）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "100", Type = typeof(int))]
        public string VIDEO_CLIP_BOX_AUTO_MOVE_SPEED { get; set; }

        /// <summary>
        /// 剪切框自动移动持续帧数（单位：帧数）
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "50", Type = typeof(int))]
        public string VIDEO_CLIP_BOX_AUTO_MOVE_DURATION_FRAME { get; set; }

        /// <summary>
        /// 视频边线检测多边形区域透明度
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "0.15", Type = typeof(double))]
        public string VIDEO_SIDE_CHECK_POLYGON_OPACITY { get; set; }

        /// <summary>
        /// 手动校准区域透明度
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "0.2", Type = typeof(double))]
        public string VIDEO_MANUAL_CORRECTION_OPACITY { get; set; }

        /// <summary>
        /// 中心轴宽度
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "2", Type = typeof(int))]
        public string VIDEO_CENTER_AXIS_WIDTH { get; set; }

        /// <summary>
        /// 中心轴颜色
        /// </summary>
        [Ini(Section = "Video", DefaultValue = "#44000000", Type = typeof(RawColor4))]
        public string VIDEO_CENTER_AXIS_COLOR { get; set; }
    }
}
