﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Diagnostics;
using VIZ.Framework.Core;
using Newtonsoft.Json;

namespace VIZ.Framework.UnitTest
{
    public class Student
    {
        public string Name { get; set; }

        public int Age { get; set; }
    }

    /// <summary>
    /// JSON测试
    /// </summary>
    [TestClass]
    public class JsonTest
    {
        /// <summary>
        /// Python Json 测试
        /// </summary>
        [TestMethod]
        public void PythonJsonTest()
        {
            Student student = new Student();
            student.Name = null;
            student.Age = 17;

            JsonSerializerSettings settings = new JsonSerializerSettings();
            settings.NullValueHandling = NullValueHandling.Ignore;
            string str = JsonConvert.SerializeObject(student, settings);


        }

        /// <summary>
        /// 时间测试
        /// </summary>
        [TestMethod]
        public void TimeTest()
        {
            // 16612406883518854
            long begin = new DateTime(1970, 1, 1, 8, 0, 0).Ticks;
            // 16613510251790000
            // 16612406883518854
            // 16615034160040000
            // 16615032962820000
            // 2022-08-26 16-43-36.0040000
            // 2022-08-26 16:43:36,094
            //
            // 2022-08-26 16-41-36.2820000
            // 2022-08-26 16:41:36,370
            //DateTime time = new DateTime(16615032962820000 + begin);

            //            string str = time.ToString("yyyy-MM-dd HH-mm-ss.fffffff");

            string str = 1.123456789d.ToString("P2");
        }
    }
}
