﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Diagnostics;
using VIZ.Framework.Core;

namespace VIZ.Framework.UnitTest
{
    /// <summary>
    /// 监控测试
    /// </summary>
    [TestClass]
    public class MonitorTask
    {
        private MonitorManager manager = new MonitorManager();

        /// <summary>
        /// 初始化
        /// </summary>
        [TestInitialize]
        public void Initialize()
        {
            this.manager.AppendTask(new SystemMonitorTask());

            this.manager.Start();
        }

        /// <summary>
        /// 清理
        /// </summary>
        [TestCleanup]
        public void Cleanup()
        {
            this.manager.Stop();
        }

        /// <summary>
        /// 系统监视测试
        /// </summary>
        [TestMethod]
        public void SystemTest()
        {
            SystemMonitorInfo info = this.manager.GetInfo<SystemMonitorInfo>("System");

            int i = 0;
            while (i++ < 30)
            {
                System.Threading.Thread.Sleep(1000);

                Debug.WriteLine("--------------------------------------");
                Debug.WriteLine($"CPU: {info.CpuUsedPercentage}");
                Debug.WriteLine($"内存: {info.MemoryUsedPercentage}");
                Debug.WriteLine("--------------------------------------");
            }
        }

        /// <summary>
        /// 字节大小转化测试
        /// </summary>
        [TestMethod]
        public void BitSizeConverterTest()
        {
            ByteSizeConverter converter = new ByteSizeConverter();
            converter.InType = ByteSizeType.B;
            converter.OutType = ByteSizeType.MB;
            object r = converter.Convert(1024 * 1024, null, null, null);

            object rb = converter.ConvertBack(r, null, null, null);
        }
    }
}
