﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TDx.SpaceMouse.Navigation3D;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标管理器
    /// </summary>
    public static class Navigation3DManager
    {
        /// <summary>
        /// 3D鼠标模型
        /// </summary>
        public static Navigation3DModel Navigation3DModel { get; private set; }

        /// <summary>
        /// 3D鼠标
        /// </summary>
        public static Navigation3D Navigation3D { get; private set; }

        /// <summary>
        /// 初始化
        /// </summary>
        /// <param name="profileName">3D鼠标配置名称</param>
        /// <param name="maxX">X偏移量最大值</param>
        public static void Init(string profileName, double maxX)
        {
            Navigation3DModel = new Navigation3DModel();
            Navigation3DModel.MaxX = maxX;

            Navigation3D = new Navigation3D(Navigation3DModel);
            Navigation3D.FrameTiming = Navigation3D.TimingSource.SpaceMouse;
            Navigation3D.Open3DMouse(profileName);
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public static void Dispose()
        {
            Navigation3D?.Close();
            Navigation3DModel = null;
            Navigation3D = null;
        }
    }
}
