﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TDx.SpaceMouse.Navigation3D;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标模型 INavigation
    /// </summary>
    public partial class Navigation3DModel : INavigation3D
    {
        public Matrix GetCameraMatrix()
        {
#if DEBUG
            Debug.WriteLine("GetCameraMatrix");
#endif

            return this.Camera.Matrix;
        }

        public Point GetCameraTarget()
        {
#if DEBUG
            Debug.WriteLine("GetCameraTarget");
#endif

            return this.Camera.Position;
        }

        public Matrix GetCoordinateSystem()
        {
#if DEBUG
            Debug.WriteLine("GetCoordinateSystem");
#endif

            return Matrix.Identity;
        }

        public Matrix GetFrontView()
        {
#if DEBUG
            Debug.WriteLine("GetFrontView");
#endif

            return Matrix.Identity;
        }

        public Point GetLookAt()
        {
#if DEBUG
            Debug.WriteLine("GetLookAt");
#endif

            return new Point(0, 0, -1);
        }

        public Box GetModelExtents()
        {
#if DEBUG
            Debug.WriteLine("GetModelExtents");
#endif

            return new Box(-1, -1, 0, 1, 1, 0);
        }

        public Point GetPivotPosition()
        {
#if DEBUG
            Debug.WriteLine("GetPivotPosition");
#endif

            return new Point();
        }

        public Point GetPointerPosition()
        {
#if DEBUG
            Debug.WriteLine("GetPointerPosition");
#endif

            return new Point();
        }

        public Box GetSelectionExtents()
        {
#if DEBUG
            Debug.WriteLine("GetSelectionExtents");
#endif

            return new Box(-1, -1, 0, 1, 1, 0);
        }

        public Matrix GetSelectionTransform()
        {
#if DEBUG
            Debug.WriteLine("GetSelectionTransform");
#endif

            return Matrix.Identity;
        }

        public Plane GetViewConstructionPlane()
        {
#if DEBUG
            Debug.WriteLine("GetViewConstructionPlane");
#endif

            return new Plane();
        }

        public Box GetViewExtents()
        {
#if DEBUG
            Debug.WriteLine("GetViewExtents");
#endif
            return new Box(-100, -100, 0, 100, 100, 0);
        }

        public double GetViewFOV()
        {
#if DEBUG
            Debug.WriteLine("GetViewFOV");
#endif

            return 45;
        }

        public Frustum GetViewFrustum()
        {
#if DEBUG
            Debug.WriteLine("GetViewFrustum");
#endif

            return new Frustum(-0.00041, 0.00041, -0.00034, 0.00034, 0.01, 1000);
        }

        public bool IsSelectionEmpty()
        {
#if DEBUG
            Debug.WriteLine("IsSelectionEmpty");
#endif

            return true;
        }

        public bool IsUserPivot()
        {
#if DEBUG
            Debug.WriteLine("IsUserPivot");
#endif

            return false;
        }

        public bool IsViewPerspective()
        {
#if DEBUG
            Debug.WriteLine("IsViewPerspective");
#endif

            return true;
        }

        public bool IsViewRotatable()
        {
#if DEBUG
            Debug.WriteLine("IsViewRotatable");
#endif
            return false;
        }

        public void SetCameraMatrix(Matrix matrix)
        {
#if DEBUG
            Debug.WriteLine("SetCameraMatrix");
#endif
            matrix.M41 = MathHelper.Clip(-this.MaxX, this.MaxX, matrix.M41);

            this.Camera.Matrix = matrix;
            this.Camera.Position = new Point(matrix.M41, matrix.M42, matrix.M43);

#if DEBUG
            Debug.WriteLine($"({matrix.M41}, {matrix.M42})");
#endif
        }

        public void SetCameraTarget(Point target)
        {
#if DEBUG
            Debug.WriteLine("SetCameraTarget");
#endif
        }

        public void SetLookAperture(double aperture)
        {
#if DEBUG
            Debug.WriteLine("SetLookAperture");
#endif
        }

        public void SetLookDirection(Vector direction)
        {
#if DEBUG
            Debug.WriteLine("SetLookDirection");
#endif
        }

        public void SetLookFrom(Point eye)
        {
#if DEBUG
            Debug.WriteLine("SetLookFrom");
#endif
        }

        public void SetPivotPosition(Point position)
        {
#if DEBUG
            Debug.WriteLine("SetPivotPosition");
#endif
        }

        public void SetPivotVisible(bool visible)
        {
#if DEBUG
            Debug.WriteLine("SetPivotVisible");
#endif
        }

        public void SetPointerPosition(Point position)
        {
#if DEBUG
            Debug.WriteLine("SetPointerPosition");
#endif
        }

        public void SetSelectionOnly(bool onlySelection)
        {
#if DEBUG
            Debug.WriteLine("SetSelectionOnly");
#endif
        }

        public void SetSelectionTransform(Matrix matrix)
        {
#if DEBUG
            Debug.WriteLine("SetSelectionTransform");
#endif
        }

        public void SetViewExtents(Box extents)
        {
#if DEBUG
            Debug.WriteLine("SetViewExtents");
#endif
        }

        public void SetViewFOV(double fov)
        {
#if DEBUG
            Debug.WriteLine("SetViewFOV");
#endif
        }

        public void SetViewFrustum(Frustum frustum)
        {
#if DEBUG
            Debug.WriteLine("SetViewFrustum");
#endif
        }
    }
}
