﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.H2V.Connection;

namespace VIZ.Framework.UnitTest
{
    /// <summary>
    /// 监控测试
    /// </summary>
    [TestClass]
    public class NetTest
    {
        /// <summary>
        /// 获取Mac地址测试
        /// </summary>
        [TestMethod]
        public void GetMacTest()
        {
            string str = NetHelper.GetMacAddress();

            Assert.IsTrue(!string.IsNullOrWhiteSpace(str));
        }

        /// <summary>
        /// 获取可用的UDP端口
        /// </summary>
        [TestMethod]
        public void GetUdpPortTest()
        {
            int port = NetHelper.GetAvailableUdpPort(8000, 9000, null);

            try
            {
                IPEndPoint ipep = new IPEndPoint(IPAddress.Parse("127.0.0.1"), port);
                UdpClient client = new UdpClient(ipep);
            }
            catch
            {

            }

            Assert.IsTrue(port >= 8000 && port <= 20000);
        }

        [TestMethod]
        public void JosnTest()
        {
            string str = "{'signal': 'detect', 'bboxes': [[914.5606, 144.6889, 1877.504, 380.21176]], 'id': 'E0:4F:43:E6:48:C2__CAM_1'}";
            AlgorithmPackageBase @base = Newtonsoft.Json.JsonConvert.DeserializeObject<AlgorithmPackageBase>(str);
        }
    }
}
