﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Connection;
using VIZ.Framework.Domain;
using System.Diagnostics;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台包解析器 -- 下行
    /// </summary>
    /// <remarks>
    /// 1. 下行数据不保留当前状态，需要本程序保留当前状态
    /// 2. 发送 0x00 指令清除当前状态
    /// </remarks>
    public class GimbalPackageDownProvider : ConnFixedBufferPackageProvider
    {
        /// <summary>
        /// 云台包解析器
        /// </summary>
        /// <param name="fixedBufferSize">包大小</param>
        /// <param name="syncHeader">同步针头</param>
        /// <param name="upEndpointManagerKey">上行终结点管理器键</param>
        public GimbalPackageDownProvider(int fixedBufferSize, IEnumerable<byte> syncHeader, string upEndpointManagerKey) : base(fixedBufferSize, syncHeader)
        {
            this.UpEndpointManagerKey = upEndpointManagerKey;
        }

        /// <summary>
        /// 上行行终结点管理器键
        /// </summary>
        public string UpEndpointManagerKey { get; private set; }

        /// <summary>
        /// 处理器集合
        /// </summary>
        private List<IGimbalDownProvider> providers = new List<IGimbalDownProvider>();

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">信息</param>
        protected override void Execute(ConnFixedBufferInfo info)
        {
            // 解析数据
            GimbalPackage_down data = new GimbalPackage_down();
            data.FromBuffer(info.Buffer);

            // 同步帧头
            if (data.SyncHead_1 != 0xA5 || data.SyncHead_2 != 0xE7)
                return;

            // 校验数据
            byte check = data.GetCheckValue();
            if (check != data.Check)
                return;

            // 处理数据
            foreach (IGimbalDownProvider provider in this.providers)
            {
                provider.Execute(data);
            }

            // 下发数据
            SerialPortEndpointManager manager = ConnectionManager.SerialPortConnection.GetEndpointManager(this.UpEndpointManagerKey);
            if (manager == null)
                return;

            byte[] buffer = data.ToBuffer();
            manager.Send(buffer);
        }
    }
}
