﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Connection;
using VIZ.GimbalAI.Controller.Domain;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台上行数据包
    /// </summary>
    public class GimbalPackage_up : GimbalPackageBase
    {
        /// <summary>
        /// 同步帧头 固定值 0x58
        /// </summary>
        [ConnBitLength(8)]
        public byte SyncHead_1 { get; set; }

        /// <summary>
        /// 同步帧头 固定值 0xA0
        /// </summary>
        [ConnBitLength(8)]
        public byte SyncHead_2 { get; set; }

        /// <summary>
        /// 状态字
        /// <see cref="GimbalPackage_Commands"/>
        /// </summary>
        [ConnBitLength(8)]
        public byte Command { get; set; }

        /// <summary>
        /// 俯仰角度值
        /// </summary>
        [ConnBitLength(15)]
        public Int16 Vertical { get; set; }

        /// <summary>
        /// 方位角度值
        /// </summary>
        [ConnBitLength(15)]
        public Int16 Horizontal { get; set; }

        /// <summary>
        /// 横滚角度值
        /// </summary>
        [ConnBitLength(16)]
        public Int16 Roll { get; set; }

        /// <summary>
        /// 变焦值
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Zoom { get; set; }

        /// <summary>
        /// 光圈值
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Aperture { get; set; }

        /// <summary>
        /// 聚焦值
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Focus { get; set; }

        /// <summary>
        /// 心跳指令
        /// </summary>
        [ConnBitLength(8)]
        public byte Heart { get; set; }

        /// <summary>
        /// 处理后的俯仰角
        /// </summary>
        [ConnBitLength(16)]
        public Int16 Real_Vertical_Angle { get; set; }

        /// <summary>
        /// 处理后的方位角
        /// </summary>
        [ConnBitLength(16)]
        public Int16 Real_Horizontal_Angle { get; set; }

        /// <summary>
        /// 处理后的变焦值
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Real_Zoom { get; set; }

        /// <summary>
        /// 处理后的焦点位置
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Real_Focus { get; set; }

        /// <summary>
        /// 校验和
        /// （序号1+……+序号52）&0xFF
        /// </summary>
        [ConnBitLength(8)]
        public byte Check { get; set; }

        /// <summary>
        /// 将对象转化为二进制数据
        /// </summary>
        /// <returns>二进制数据</returns>
        public override byte[] ToBuffer()
        {
            byte[] buffer = new byte[53];

            int index = 0;
            // 同步帧头 1
            buffer[index++] = this.SyncHead_1;
            // 同步帧头 2
            buffer[index++] = this.SyncHead_2;
            // 命令字
            buffer[index++] = this.Command;
            // 俯仰
            buffer[index++] = this.GetBuffer_2_low(this.Vertical);
            buffer[index++] = this.GetBuffer_2_heigh(this.Vertical);
            // 方位
            buffer[index++] = this.GetBuffer_2_low(this.Horizontal);
            buffer[index++] = this.GetBuffer_2_heigh(this.Horizontal);
            // 横滚
            buffer[index++] = this.GetBuffer_2_low(this.Roll);
            buffer[index++] = this.GetBuffer_2_heigh(this.Roll);
            // 变焦
            buffer[index++] = this.GetBuffer_2_low(this.Zoom);
            buffer[index++] = this.GetBuffer_2_heigh(this.Zoom);
            // 光圈
            buffer[index++] = this.GetBuffer_2_low(this.Aperture);
            buffer[index++] = this.GetBuffer_2_heigh(this.Aperture);
            // 聚焦
            buffer[index++] = this.GetBuffer_2_low(this.Focus);
            buffer[index++] = this.GetBuffer_2_heigh(this.Focus);
            // 心跳
            buffer[index++] = this.Heart;
            // 处理后的俯仰角度值
            buffer[index++] = this.GetBuffer_2_low(this.Real_Vertical_Angle);
            buffer[index++] = this.GetBuffer_2_heigh(this.Real_Vertical_Angle);
            // 处理后的方位角度值
            buffer[index++] = this.GetBuffer_2_low(this.Real_Horizontal_Angle);
            buffer[index++] = this.GetBuffer_2_heigh(this.Real_Horizontal_Angle);
            // 变焦值            
            buffer[index++] = this.GetBuffer_2_low(this.Real_Zoom);
            buffer[index++] = this.GetBuffer_2_heigh(this.Real_Zoom);
            // 焦点位置
            buffer[index++] = this.GetBuffer_2_low(this.Real_Focus);
            buffer[index++] = this.GetBuffer_2_heigh(this.Real_Focus);
            // 备用
            index += 28;
            // 校验值
            buffer[index++] = this.Check;

            return buffer;
        }

        /// <summary>
        /// 从二进制数据中获取数据
        /// </summary>
        /// <param name="buffer">二进制数据</param>
        public override void FromBuffer(byte[] buffer)
        {
            int index = 0;
            // 同步帧头 1
            this.SyncHead_1 = buffer[index++];
            // 同步帧头 2
            this.SyncHead_2 = buffer[index++];
            // 命令字
            this.Command = buffer[index++];
            // 俯仰
            this.Vertical = this.GetValue_2_NoPN2(buffer, index);
            index += 2;
            // 方位
            this.Horizontal = this.GetValue_2_NoPN2(buffer, index);
            index += 2;
            // 横滚
            this.Roll = this.GetValue_2_NoPN2(buffer, index);
            index += 2;
            // 变焦
            this.Zoom = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 光圈
            this.Aperture = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 聚焦
            this.Focus = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 心跳
            this.Heart = buffer[index++];
            // 处理后的俯仰角度值
            this.Real_Vertical_Angle = this.GetValue_2_NoPN2(buffer, index);
            index += 2;
            // 处理后的方位角度值
            this.Real_Horizontal_Angle = this.GetValue_2_NoPN2(buffer, index);
            index += 2;
            // 变焦值      
            this.Real_Zoom = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 焦点位置
            this.Real_Focus = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 备用 1
            index += 28;
            // 校验值
            this.Check = buffer[index++];
        }

        /// <summary>
        /// 获取校验值
        /// </summary>
        /// <returns>是否通过校验</returns>
        public override byte GetCheckValue()
        {
            byte[] buffer = this.ToBuffer();

            long sum = 0;
            for (int i = 0; i < buffer.Length - 1; i++)
            {
                sum += buffer[i];
            }

            return (byte)(sum & 0xFF);
        }
    }
}
