﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台数据包序列化
    /// </summary>
    public interface IGimbalPackageSerialize
    {
        /// <summary>
        /// 将对象转化为二进制数据
        /// </summary>
        /// <returns>二进制数据</returns>
        byte[] ToBuffer();

        /// <summary>
        /// 从二进制数据中获取数据
        /// </summary>
        /// <param name="buffer">二进制数据</param>
        void FromBuffer(byte[] buffer);

        /// <summary>
        /// 获取校验值
        /// </summary>
        /// <returns>是否通过校验</returns>
        byte GetCheckValue();
    }
}
