﻿using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Connection;
using VIZ.Framework.Module;
using VIZ.GimbalAI.Controller.Connection;
using VIZ.GimbalAI.Controller.Domain;

namespace VIZ.GimbalAI.Controller.Module
{
    /// <summary>
    /// 应用程序启动 -- 串口
    /// </summary>
    public class AppSetup_SerialPort : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_SerialPort));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 串口";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            ConnectionManager.SerialPortConnection = new SerialPortConnection();

            // 下行
            SerialPortEndpointManager down_endpoint_manager = new SerialPortEndpointManager(SerialPortKeys.DOWN, "COM4", 115200, Parity.None, 8, StopBits.One);
            down_endpoint_manager.PackageProvider = new GimbalPackageDownProvider(53, new byte[] { 0xA5, 0xE7 }, SerialPortKeys.DOWN);
            ConnectionManager.SerialPortConnection.AddEndpointManager(down_endpoint_manager);

            down_endpoint_manager.Open();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }
    }
}
