﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Connection;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台下行数据包
    /// </summary>
    public class GimbalPackage_down : GimbalPackageBase
    {
        /// <summary>
        /// 同步帧头 固定值 0xA5
        /// </summary>
        [ConnBitLength(8)]
        public byte SyncHead_1 { get; set; }

        /// <summary>
        /// 同步帧头 固定值 0xE7
        /// </summary>
        [ConnBitLength(8)]
        public byte SyncHead_2 { get; set; }

        /// <summary>
        /// 命令正反装指令
        /// 0 -- 正装 | 1 -- 负装
        /// </summary>
        [ConnBitLength(1)]
        public byte Command_PN { get; set; }

        /// <summary>
        /// 命令 指令
        /// <see cref="GimbalPackage_Commands"/>
        /// </summary>
        [ConnBitLength(7)]
        public byte Command { get; set; }

        /// <summary>
        /// 俯仰值方向
        /// 0 -- 正数 | 1 -- 负数
        /// </summary>
        [ConnBitLength(1)]
        public byte Vertical_PN { get; set; }

        /// <summary>
        /// 俯仰值
        /// </summary>
        [ConnBitLength(15)]
        public UInt16 Vertical { get; set; }

        /// <summary>
        /// 方位值方向
        /// 0 -- 正数 | 1 -- 负数
        /// </summary>
        [ConnBitLength(1)]
        public byte Horizontal_PN { get; set; }

        /// <summary>
        /// 方位值
        /// </summary>
        [ConnBitLength(15)]
        public UInt16 Horizontal { get; set; }

        /// <summary>
        /// 横滚控制
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Roll { get; set; }

        /// <summary>
        /// 变焦控制
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Zoom { get; set; }

        /// <summary>
        /// 光圈
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Aperture { get; set; }

        /// <summary>
        /// 聚焦
        /// </summary>
        [ConnBitLength(16)]
        public UInt16 Focus { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        [ConnBitLength(8)]
        public byte Brand { get; set; }

        /// <summary>
        /// 跟踪俯仰值方向
        /// 0 -- 正数 | 1 -- 负数
        /// </summary>
        [ConnBitLength(1)]
        public byte Track_Vertical_PN { get; set; }

        /// <summary>
        /// 跟踪俯仰值
        /// </summary>
        [ConnBitLength(15)]
        public UInt16 Track_Vertical { get; set; }

        /// <summary>
        /// 跟踪方位值方向
        /// 0 -- 正数 | 1 -- 负数
        /// </summary>
        [ConnBitLength(1)]
        public byte Track_Horizontal_PN { get; set; }

        /// <summary>
        /// 跟踪方位值
        /// </summary>
        [ConnBitLength(15)]
        public UInt16 Track_Horizontal { get; set; }

        /// <summary>
        /// 心跳
        /// </summary>
        [ConnBitLength(8)]
        public byte Heart { get; set; }

        /// <summary>
        /// 校验和
        /// （序号1+……+序号52）&0xFF
        /// </summary>
        [ConnBitLength(8)]
        public byte Check { get; set; }

        /// <summary>
        /// 将对象转化为二进制数据
        /// </summary>
        /// <returns>二进制数据</returns>
        public override byte[] ToBuffer()
        {
            byte[] buffer = new byte[53];

            int index = 0;
            // 同步帧头 1
            buffer[index++] = this.SyncHead_1;
            // 同步帧头 2
            buffer[index++] = this.SyncHead_2;
            // 命令字
            buffer[index++] = this.GetBuffer_1(this.Command_PN, this.Command);
            // 俯仰
            buffer[index++] = this.GetBuffer_2_low(this.Vertical_PN, this.Vertical);
            buffer[index++] = this.GetBuffer_2_heigh(this.Vertical_PN, this.Vertical);
            // 方位
            buffer[index++] = this.GetBuffer_2_low(this.Horizontal_PN, this.Horizontal);
            buffer[index++] = this.GetBuffer_2_heigh(this.Horizontal_PN, this.Horizontal);
            // 横滚
            buffer[index++] = this.GetBuffer_2_low(this.Roll);
            buffer[index++] = this.GetBuffer_2_heigh(this.Roll);
            // 变焦
            buffer[index++] = this.GetBuffer_2_low(this.Zoom);
            buffer[index++] = this.GetBuffer_2_heigh(this.Zoom);
            // 光圈
            buffer[index++] = this.GetBuffer_2_low(this.Aperture);
            buffer[index++] = this.GetBuffer_2_heigh(this.Aperture);
            // 聚焦
            buffer[index++] = this.GetBuffer_2_low(this.Focus);
            buffer[index++] = this.GetBuffer_2_heigh(this.Focus);
            // 品牌
            buffer[index++] = this.Brand;
            // 跟踪俯仰
            buffer[index++] = this.GetBuffer_2_low(this.Track_Vertical_PN, this.Track_Vertical);
            buffer[index++] = this.GetBuffer_2_heigh(this.Track_Vertical_PN, this.Track_Vertical);
            // 跟踪方位
            buffer[index++] = this.GetBuffer_2_low(this.Track_Horizontal_PN, this.Track_Horizontal);
            buffer[index++] = this.GetBuffer_2_heigh(this.Track_Horizontal_PN, this.Track_Horizontal);
            // 备用 
            index += 31;
            // 心跳
            buffer[index++] = this.Heart;
            // 校验值
            buffer[index++] = this.Check;

            return buffer;
        }

        /// <summary>
        /// 从二进制数据中获取数据
        /// </summary>
        /// <param name="buffer">二进制数据</param>
        public override void FromBuffer(byte[] buffer)
        {
            int index = 0;
            // 同步帧头 1
            this.SyncHead_1 = buffer[index++];
            // 同步帧头 2
            this.SyncHead_2 = buffer[index++];
            // 命令字
            this.Command_PN = this.GetPN_1(buffer, index);
            this.Command = this.GetValue_1(buffer, index);
            index += 1;
            // 俯仰
            this.Vertical_PN = this.GetPN_2(buffer, index);
            this.Vertical = this.GetValue_2(buffer, index);
            index += 2;
            // 方位
            this.Horizontal_PN = this.GetPN_2(buffer, index);
            this.Horizontal = this.GetValue_2(buffer, index);
            index += 2;
            // 横滚
            this.Roll = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 变焦
            this.Zoom = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 光圈
            this.Aperture = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 聚焦
            this.Focus = this.GetValue_2_NoPN(buffer, index);
            index += 2;
            // 品牌
            this.Brand = buffer[index++];
            // 跟踪俯仰
            this.Track_Vertical_PN = this.GetPN_2(buffer, index);
            this.Track_Vertical = this.GetValue_2(buffer, index);
            index += 2;
            // 跟踪方位
            this.Track_Horizontal_PN = this.GetPN_2(buffer, index);
            this.Track_Horizontal = this.GetValue_2(buffer, index);
            index += 2;
            // 备用 
            index += 31;
            // 心跳
            this.Heart = buffer[index++];
            // 校验值
            this.Check = buffer[index++];
        }

        /// <summary>
        /// 获取校验值
        /// </summary>
        /// <returns>是否通过校验</returns>
        public override byte GetCheckValue()
        {
            byte[] buffer = this.ToBuffer();

            long sum = 0;
            for (int i = 0; i < buffer.Length - 1; i++)
            {
                sum += buffer[i];
            }

            return (byte)(sum & 0xFF);
        }
    }
}
