﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台数据包基类
    /// </summary>
    public abstract class GimbalPackageBase : IGimbalPackageSerialize
    {
        /// <summary>
        /// 时间 yyyy-MM-dd HH:mm:ss fff
        /// </summary>
        public string DateTime { get; set; }

        /// <summary>
        /// 获取一个字节数据的正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <returns>当前位序</returns>
        protected byte GetPN_1(byte[] buffer, int index)
        {
            return (byte)((buffer[index] & 0b10000000) >> 7);
        }

        /// <summary>
        /// 获取一个字节数据的值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected byte GetValue_1(byte[] buffer, int index)
        {
            return (byte)(buffer[index] & 0b01111111);
        }

        /// <summary>
        /// 获取两个字节数据的额正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <returns>当前位序</returns>
        protected byte GetPN_2(byte[] buffer, int index)
        {
            return (byte)((buffer[index + 1] & 0b10000000) >> 7);
        }

        /// <summary>
        /// 获取两个字节数据的值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected UInt16 GetValue_2(byte[] buffer, int index)
        {
            return (UInt16)(buffer[index] + ((buffer[index + 1] & 0b01111111) << 8));
        }

        /// <summary>
        /// 获取两个字节数据的值，没有正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected UInt16 GetValue_2_NoPN(byte[] buffer, int index)
        {
            return (UInt16)(buffer[index] + (buffer[index + 1] << 8));
        }

        /// <summary>
        /// 获取两个字节数据的值，没有正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected Int16 GetValue_2_NoPN2(byte[] buffer, int index)
        {
            return (Int16)(buffer[index] + (buffer[index + 1] << 8));
        }

        /// <summary>
        /// 获取四个字节数据的值，没有正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected UInt32 GetValue_4_NoPN(byte[] buffer, int index)
        {
            return (UInt32)(buffer[index] + (buffer[index + 1] << 8) + (buffer[index + 2] << 16) + (buffer[index + 3] << 24));
        }

        /// <summary>
        /// 获取四个字节数据的值，没有正负值
        /// </summary>
        /// <param name="buffer">Buffer</param>
        /// <param name="index">当前位序</param>
        /// <returns>值</returns>
        protected Int32 GetValue_4_NoPN2(byte[] buffer, int index)
        {
            return (Int32)(buffer[index] + (buffer[index + 1] << 8) + (buffer[index + 2] << 16) + (buffer[index + 3] << 24));
        }

        /// <summary>
        /// 获取1个字节数据
        /// </summary>
        /// <param name="pn">符号位</param>
        /// <param name="value">值</param>
        /// <returns>字节数据</returns>
        protected byte GetBuffer_1(byte pn, byte value)
        {
            return (byte)(((UInt16)pn << 7) + value);
        }

        /// <summary>
        /// 获取2个字节数据的低位
        /// </summary>
        /// <param name="pn">符号</param>
        /// <param name="value">值</param>
        /// <returns>低位字节</returns>
        protected byte GetBuffer_2_low(byte pn, UInt16 value)
        {
            return (byte)((value + (pn << 15)) & 0b0000000011111111);
        }

        /// <summary>
        /// 获取2个字节数据的高位
        /// </summary>
        /// <param name="pn">符号</param>
        /// <param name="value">值</param>
        /// <returns>高位字节</returns>
        protected byte GetBuffer_2_heigh(byte pn, UInt16 value)
        {
            return (byte)(((value + (pn << 15)) & 0b1111111100000000) >> 8);
        }

        /// <summary>
        /// 获取2个字节数据的低位
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>低位字节</returns>
        protected byte GetBuffer_2_low(UInt16 value)
        {
            return (byte)(value & 0b0000000011111111);
        }

        /// <summary>
        /// 获取2个字节数据的高位
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>高位数据</returns>
        protected byte GetBuffer_2_heigh(UInt16 value)
        {
            return (byte)((value & 0b1111111100000000) >> 8);
        }

        /// <summary>
        /// 获取2个字节数据的低位
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>低位字节</returns>
        protected byte GetBuffer_2_low(Int16 value)
        {
            return (byte)(value & 0b0000000011111111);
        }

        /// <summary>
        /// 获取2个字节数据的高位
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>高位数据</returns>
        protected byte GetBuffer_2_heigh(Int16 value)
        {
            return (byte)((value & 0b1111111100000000) >> 8);
        }

        /// <summary>
        /// 获取4个字节数据
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>字节数据</returns>
        protected byte[] GetBuffer_4(UInt32 value)
        {
            // 00000000
            // 11111111
            byte[] result = new byte[4];
            result[0] = (byte)(value & 0b00000000000000000000000011111111);
            result[1] = (byte)((value & 0b00000000000000001111111100000000) >> 8);
            result[2] = (byte)((value & 0b00000000111111110000000000000000) >> 16);
            result[3] = (byte)((value & 0b11111111000000000000000000000000) >> 24);

            return result;
        }

        /// <summary>
        /// 获取4个字节数据
        /// </summary>
        /// <param name="value">值</param>
        /// <returns>字节数据</returns>
        protected byte[] GetBuffer_4(Int32 value)
        {
            // 00000000
            // 11111111
            byte[] result = new byte[4];
            result[0] = (byte)(value & 0b00000000000000000000000011111111);
            result[1] = (byte)((value & 0b00000000000000001111111100000000) >> 8);
            result[2] = (byte)((value & 0b00000000111111110000000000000000) >> 16);
            result[3] = (byte)((value & 0b11111111000000000000000000000000) >> 24);

            return result;
        }

        /// <summary>
        /// 获取带PN的值
        /// </summary>
        /// <param name="pn">符号位</param>
        /// <param name="value">值</param>
        /// <returns>带PN的值</returns>
        protected UInt16 GetValueWithPN(byte pn, byte value)
        {
            return (UInt16)((pn << 7) + value);
        }

        /// <summary>
        /// 获取带PN的值
        /// </summary>
        /// <param name="pn">符号位</param>
        /// <param name="value">值</param>
        /// <returns>带PN的值</returns>
        protected UInt16 GetValueWithPN(byte pn, UInt16 value)
        {
            return (UInt16)(value + ((UInt16)(pn) << 15));
        }

        /// <summary>
        /// 将对象转化为二进制数据
        /// </summary>
        /// <returns>二进制数据</returns>
        public abstract byte[] ToBuffer();

        /// <summary>
        /// 从二进制数据中获取数据
        /// </summary>
        /// <param name="buffer">二进制数据</param>
        public abstract void FromBuffer(byte[] buffer);

        /// <summary>
        /// 获取校验值
        /// </summary>
        /// <returns>是否通过校验</returns>
        public abstract byte GetCheckValue();
    }
}
