﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Connection;
using VIZ.Framework.Core;
using VIZ.Framework.Module;
using VIZ.GimbalAI.Controller.Connection;
using VIZ.GimbalAI.Controller.Domain;

namespace VIZ.GimbalAI.Controller.Module
{
    /// <summary>
    /// 主视图模型
    /// </summary>
    public class MainViewModel : ViewModelBase, IGimbalSignalSaveSupport
    {
        public MainViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // 初始化控制器
            this.InitController();

            // 初始化消息
            this.InitMessage();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.OpenDataFolderCommand = new VCommand(this.OpenDataFolder);
        }

        /// <summary>
        /// 初始化消息
        /// </summary>
        private void InitMessage()
        {
            ApplicationDomainEx.MessageManager.Register<AppShutDownMessage>(this, this.OnAppShutDownMessage);
            ApplicationDomainEx.MessageManager.Register<ConnFixedBufferMessage>(this, this.OnConnFixedBufferMessage);

        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void InitController()
        {
            this.GimbalSignalSaveController = new GimbalSignalSaveController(this);
            this.GimbalSignalSaveController.Start();
        }

        /// <summary>
        /// 云台信号保存控制器
        /// </summary>
        private GimbalSignalSaveController GimbalSignalSaveController;

        // ------------------------------------------------------------------------------------
        // Property
        // ------------------------------------------------------------------------------------

        #region CurrentCommandStatus -- 当前命令状态

        private GimbalPackage_Commands currentCommandStatus;
        /// <summary>
        /// 当前命令状态
        /// </summary>
        public GimbalPackage_Commands CurrentCommandStatus
        {
            get { return currentCommandStatus; }
            set { currentCommandStatus = value; this.RaisePropertyChanged(nameof(CurrentCommandStatus)); }
        }

        #endregion

        #region DownData -- 下行数据

        private GimbalPackage_down downData;
        /// <summary>
        /// 下行数据
        /// </summary>
        public GimbalPackage_down DownData
        {
            get { return downData; }
            set { downData = value; this.RaisePropertyChanged(nameof(DownData)); }
        }

        #endregion

        #region UpData -- 上行数据

        private GimbalPackage_up upData;
        /// <summary>
        /// 上行数据
        /// </summary>
        public GimbalPackage_up UpData
        {
            get { return upData; }
            set { upData = value; this.RaisePropertyChanged(nameof(UpData)); }
        }

        #endregion

        // ------------------------------------------------------------------------------------
        // Command 
        // ------------------------------------------------------------------------------------

        #region OpenDataFolderCommand -- 打开数据文件夹命令

        /// <summary>
        /// 打开数据文件夹命令
        /// </summary>
        public VCommand OpenDataFolderCommand { get; set; }

        /// <summary>
        /// 打开数据文件夹
        /// </summary>
        private void OpenDataFolder()
        {
            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "data");
            if (!Directory.Exists(path))
                return;

            System.Diagnostics.Process.Start(path);
        }

        #endregion

        // ------------------------------------------------------------------------------------
        // Message
        // ------------------------------------------------------------------------------------

        /// <summary>
        /// 应用程序停止消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnAppShutDownMessage(AppShutDownMessage msg)
        {
            this.GimbalSignalSaveController.Stop();
        }

        /// <summary>
        /// 处理上行 & 下行 数据消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnConnFixedBufferMessage(ConnFixedBufferMessage msg)
        {
            this.GimbalSignalSaveController.MessageQueue.Enqueue(msg);
        }

        // ------------------------------------------------------------------------------------
        // Public Function
        // ------------------------------------------------------------------------------------


    }
}
