﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Connection;
using VIZ.Framework.Domain;

namespace VIZ.GimbalAI.Controller.Connection
{
    /// <summary>
    /// 云台包解析器 上行
    /// </summary>
    /// <remarks>
    /// 1. 上行数据保留有状态
    /// </remarks>
    public class GimbalPackageUpProvider : ConnFixedBufferPackageProvider
    {
        /// <summary>
        /// 云台包解析器
        /// </summary>
        /// <param name="fixedBufferSize">包大小</param>
        /// <param name="syncHeader">同步针头</param>
        /// <param name="upEndpointManagerKey">上行终结点管理器键</param>
        public GimbalPackageUpProvider(int fixedBufferSize, IEnumerable<byte> syncHeader, string upEndpointManagerKey) : base(fixedBufferSize, syncHeader)
        {
            this.UpEndpointManagerKey = upEndpointManagerKey;
        }

        /// <summary>
        /// 上行终结点管理器键
        /// </summary>
        public string UpEndpointManagerKey { get; private set; }

        /// <summary>
        /// 处理器集合
        /// </summary>
        private List<IGimbalUpProvider> providers = new List<IGimbalUpProvider>();

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">信息</param>
        protected override void Execute(ConnFixedBufferInfo info)
        {
            // 解析数据
            GimbalPackage_up data = new GimbalPackage_up();
            data.FromBuffer(info.Buffer);

            // 处理数据
            foreach (IGimbalUpProvider provider in this.providers)
            {
                provider.Execute(data);
            }

            // 上发数据
            SerialPortEndpointManager manager = ConnectionManager.SerialPortConnection.GetEndpointManager(this.UpEndpointManagerKey);
            if (manager == null)
                return;

            byte[] buffer = data.ToBuffer();
            manager.Send(buffer);
        }
    }
}
