﻿using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Connection;
using VIZ.Framework.Module;
using VIZ.GimbalAI.Controller.Connection;
using VIZ.GimbalAI.Controller.Domain;
using VIZ.GimbalAI.Controller.Storage;

namespace VIZ.GimbalAI.Controller.Module
{
    /// <summary>
    /// 应用程序启动 -- 串口
    /// </summary>
    public class AppSetup_SerialPort : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_SerialPort));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 串口";

        /// <summary>
        /// 下行数据串口号（摇杆 -> 云台）
        /// </summary>
        private readonly string GIMBAL_SERIAL_PORT_DOWN = ApplicationDomainEx.IniStorage.GetValue<GimbalConfig, string>(p => p.GIMBAL_SERIAL_PORT_DOWN);

        /// <summary>
        /// 上行护具串口号（云台 -> 摇杆）
        /// </summary>
        private readonly string GIMBAL_SERIAL_PORT_UP = ApplicationDomainEx.IniStorage.GetValue<GimbalConfig, string>(p => p.GIMBAL_SERIAL_PORT_UP);

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            ConnectionManager.SerialPortConnection = new SerialPortConnection();

            // 下行
            SerialPortEndpointManager down_endpoint_manager = new SerialPortEndpointManager(SerialPortKeys.DOWN, GIMBAL_SERIAL_PORT_DOWN, 115200, Parity.None, 8, StopBits.One);
            down_endpoint_manager.PackageProvider = new GimbalPackageDownProvider(53, new byte[] { 0xA5, 0xE7 }, SerialPortKeys.DOWN);
            ConnectionManager.SerialPortConnection.AddEndpointManager(down_endpoint_manager);

            down_endpoint_manager.Open();

            // 上行
            SerialPortEndpointManager up_endpoint_manager = new SerialPortEndpointManager(SerialPortKeys.UP, GIMBAL_SERIAL_PORT_UP, 115200, Parity.None, 8, StopBits.One);
            up_endpoint_manager.PackageProvider = new GimbalPackageUpProvider(53, new byte[] { 0x58, 0xA0 }, SerialPortKeys.UP);
            ConnectionManager.SerialPortConnection.AddEndpointManager(up_endpoint_manager);

            up_endpoint_manager.Open();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ConnectionManager.SerialPortConnection.Dispose();
        }
    }
}
