﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Connection;
using VIZ.Framework.Core;
using VIZ.GimbalAI.Controller.Connection;
using VIZ.GimbalAI.Controller.Domain;

namespace VIZ.GimbalAI.Controller.Module
{
    /// <summary>
    /// MainView.xaml 的交互逻辑
    /// </summary>
    public partial class MainView : UserControl
    {
        public MainView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, new MainViewModel());
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            SerialPortEndpointManager down_endpoint_manager = ConnectionManager.SerialPortConnection.GetEndpointManager(SerialPortKeys.DOWN);

            GimbalPackage_up up = new GimbalPackage_up();
            up.SyncHead_1 = 0x58;
            up.SyncHead_2 = 0xA0;
            up.Command = (byte)GimbalPackage_Commands.Normal;
            up.Vertical = 100;
            up.Horizontal = 100;
            up.Zoom = 100;
            up.Aperture = 100;
            up.Focus = 100;
            up.Roll = 100;
            up.Real_Horizontal_Angle = -60;
            up.Real_Vertical_Angle = 60;
            up.Check = up.GetCheckValue();

            byte[] buffer = up.ToBuffer();

            down_endpoint_manager.Send(buffer);
        }
    }
}
