﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using VIZ.Framework.Connection;
using VIZ.GimbalAI.Controller.Connection;
using VIZ.GimbalAI.Controller.Domain;

namespace VIZ.GimbalAI.Controller.UnitTest
{
    /// <summary>
    /// 二进制数据测试
    /// </summary>
    [TestClass]
    public class BufferTest
    {
        /// <summary>
        /// 下行数据测试
        /// </summary>
        [TestMethod]
        public void DownBufferTest()
        {
            GimbalPackage_down down = new GimbalPackage_down();
            down.SyncHead_1 = 0xA5;
            down.SyncHead_2 = 0xE7;
            down.Command_PN = 1;
            down.Command = (byte)GimbalPackage_Commands.Home;
            down.Vertical_PN = 1;
            down.Vertical = 1000;
            down.Horizontal_PN = 1;
            down.Horizontal = 1000;
            down.Track_Horizontal_PN = 1;
            down.Track_Horizontal = 1000;
            down.Track_Vertical_PN = 1;
            down.Track_Vertical = 1000;
            down.Zoom = 50;
            down.Aperture = 50;
            down.Focus = 50;
            down.Roll = 1000;
            down.Check = down.GetCheckValue();

            byte[] buffer = down.ToBuffer();

            GimbalPackage_down down2 = new GimbalPackage_down();
            down2.FromBuffer(buffer);


        }

        /// <summary>
        /// 上行数据测试
        /// </summary>
        [TestMethod]
        public void UpBufferTest()
        {
            GimbalPackage_up up = new GimbalPackage_up();
            up.SyncHead_1 = 0xA5;
            up.SyncHead_2 = 0xE7;
            up.Command = (byte)GimbalPackage_Commands.Home;
            up.Vertical = 1000;
            up.Horizontal = 1000;
            up.Zoom = 50;
            up.Aperture = 50;
            up.Focus = 50;
            up.Roll = 1000;
            up.Real_Horizontal_Angle = -60;
            up.Real_Vertical_Angle = 60;
            up.Real_Horizontal = 1000;
            up.Real_Vertical = 500;
            up.Check = up.GetCheckValue();

            byte[] buffer = up.ToBuffer();

            GimbalPackage_up up2 = new GimbalPackage_up();
            up2.FromBuffer(buffer);

        }
    }
}
