﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;

namespace VIZ.Package.Common
{
    /// <summary>
    /// 文本输入窗口模型
    /// </summary>
    public class TextInputWindowModel : TextInputControlModel
    {
        public TextInputWindowModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // ==========================================================================
        // Command
        // ==========================================================================

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = true;
            window.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = false;
            window.Close();
        }

        #endregion
    }
}
