﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 连接分组模型
    /// </summary>
    public class ConnGroupModel : ModelBase
    {
        #region GroupID -- 分组ID

        private Guid groupID;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID
        {
            get { return groupID; }
            set { groupID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion


        #region IsEnabled -- 是否启用

        private bool isEnabled = true;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        #region IsDefault -- 是否是默认分组

        private bool isDefault;
        /// <summary>
        /// 是否是默认分组
        /// </summary>
        public bool IsDefault
        {
            get { return isDefault; }
            set { isDefault = value; this.RaisePropertyChanged(nameof(IsDefault)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private EngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }


        #endregion

        #region Items -- 连接项集合

        private ObservableCollection<ConnModel> items = new ObservableCollection<ConnModel>();
        /// <summary>
        /// 连接项集合
        /// </summary>
        public ObservableCollection<ConnModel> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(Items)); }
        }

        #endregion

        #region IsLocalPreview -- 是否是本地预览

        private bool isLocalPreview;
        /// <summary>
        /// 是否是本地预览
        /// </summary>
        public bool IsLocalPreview
        {
            get { return isLocalPreview; }
            set { isLocalPreview = value; this.RaisePropertyChanged(nameof(IsLocalPreview)); }
        }

        #endregion

        #region Status -- 状态

        private ConnGroupStatus status;
        /// <summary>
        /// 状态
        /// </summary>
        public ConnGroupStatus Status
        {
            get { return status; }
            set { status = value; this.RaisePropertyChanged(nameof(Status)); }
        }

        #endregion


        #region CleanScreen

        /// <summary>
        /// 是否清屏操作
        /// </summary>
        private bool cleanScreen;

        public  bool CleanScreen
        {
            get { return cleanScreen; }
            set { cleanScreen = value; this.RaisePropertyChanged(nameof(CleanScreen)); }    
        }

        #endregion

        /// <summary>
        /// 更新状态
        /// </summary>
        public void UpdateStatus()
        {
            // 没有连接项 | 全断开
            if (this.Items.Count == 0 || this.Items.Where(p => p.IsEnabled).All(p => !p.IsConnected))
            {
                this.Status = ConnGroupStatus.AllDisconnection;
                return;
            }

            // 全连接
            if (this.Items.Where(p => p.IsEnabled).All(p => p.IsConnected))
            {
                this.Status = ConnGroupStatus.AllConnection;
                return;
            }

            // 部分连接
            this.Status = ConnGroupStatus.AnyConnection;
        }


    }
}
