﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 页模型
    /// </summary>
    public class PageModel : PageModelBase
    {
        #region PageID -- 页ID

        private Guid pageID;
        /// <summary>
        /// 页ID
        /// </summary>
        public Guid PageID
        {
            get { return pageID; }
            set { pageID = value; this.RaisePropertyChanged(nameof(PageID)); }
        }

        #endregion

        #region PageGroupID -- 所属页分组ID

        private Guid pageGroupID;
        /// <summary>
        /// 所属页分组ID
        /// </summary>
        public Guid PageGroupID
        {
            get { return pageGroupID; }
            set { pageGroupID = value; this.RaisePropertyChanged(nameof(PageGroupID)); }
        }

        #endregion

        #region TemplateID -- 模板ID

        private Guid templateID;
        /// <summary>
        /// 模板ID
        /// </summary>
        public Guid TemplateID
        {
            get { return templateID; }
            set { templateID = value; this.RaisePropertyChanged(nameof(TemplateID)); }
        }

        #endregion

        #region PluginID -- 插件ID

        private string pluginID;
        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID
        {
            get { return pluginID; }
            set { pluginID = value; this.RaisePropertyChanged(nameof(PluginID)); }
        }

        #endregion

        #region PluginName -- 插件名称

        private string pluginName;
        /// <summary>
        /// 插件名称
        /// </summary>
        public string PluginName
        {
            get { return pluginName; }
            set { pluginName = value; this.RaisePropertyChanged(nameof(PluginName)); }
        }

        #endregion

        #region PageNum -- 页号

        private int pageNum;
        /// <summary>
        /// 页号
        /// </summary>
        public int PageNum
        {
            get { return pageNum; }
            set { pageNum = value; this.RaisePropertyChanged(nameof(PageNum)); }
        }

        #endregion

        #region ConnGroupID -- 连接分组ID 

        private Guid connGroupID;
        /// <summary>
        /// 连接分组ID
        /// </summary>
        public Guid ConnGroupID
        {
            get { return connGroupID; }
            set
            {
                connGroupID = value;
                this.RaisePropertyChanged(nameof(ConnGroupID));
                this.SceneInfo = ApplicationDomainEx.GetSceneInfo(this);
            }
        }

        #endregion

        // =============================================================
        // 扩展属性
        // =============================================================

        #region SceneInfo -- 场景信息

        private SceneInfoModel sceneInfo;
        /// <summary>
        /// 场景信息
        /// </summary>
        public SceneInfoModel SceneInfo
        {
            get { return sceneInfo; }
            set { sceneInfo = value; this.RaisePropertyChanged(nameof(SceneInfo)); }
        }

        #endregion

        // =============================================================
        // 扩展方法
        // =============================================================

        /// <summary>
        /// 获取页号字符串
        /// </summary>
        /// <returns>页号字符串</returns>
        public string GetPageNumString()
        {
            return string.Format("{0:D4}", this.PageNum);
        }
    }
}
