﻿using DevExpress.Data;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    public class ClockEditPanelModel : EditPanelModelBase
    {
        /// <summary>
        /// 构造函数
        /// </summary>
        public ClockEditPanelModel()
        {
            //初始化方法
            InitCommand();

            //初始化加载字段值类型
            LoadValue();
        }


        public override string GetFieldValue()
        {
            return this.ControlField.Value;
        }



        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            StartCommand = new VCommand(this.Start);
            StopCommand = new VCommand(this.Stop);
            ContCommand = new VCommand(this.Cont);
            FreezeCommand = new VCommand(this.Freeze);
            UnFreezeCommand = new VCommand(this.UnFreeze);
        }


        private void LoadValue()
        {

            ClockFieldEntity clockFieldEntity = ApplicationDomainEx.ClockField;

            RadioDown = clockFieldEntity.RadioDown;
            RadioUP = clockFieldEntity.RadioUp;
        }

        #region 初始化命令
        /// <summary>
        /// 开始命令
        /// </summary>
        public VCommand StartCommand { get; set; }

        /// <summary>
        /// 开始方法
        /// </summary>
        private void Start()
        {
       
            SendTakeCmd("CLOCK0 START");

        }

        /// <summary>
        /// 停止命令
        /// </summary>
        public VCommand StopCommand { get; set; }

        /// <summary>
        /// 停止方法
        /// </summary>
        private void Stop()
        {

            SendTakeCmd("CLOCK0 STOP");

        }

        /// <summary>
        /// 继续命令
        /// </summary>
        public VCommand ContCommand { get; set; }

        /// <summary>
        /// 继续方法
        /// </summary>
        private void Cont()
        {
            SendTakeCmd("CLOCK0 CONT");
        }


        /// <summary>
        /// Viz发送命令Take命令行
        /// </summary>
        /// <param name="cmd"></param>
        private void SendTakeCmd(string cmd)
        {
            var pageModel = ApplicationDomainEx.CurrentPage as PageModel;

            ConnGroupModel group = ApplicationDomainEx.ConnGroups.FirstOrDefault(p => p.GroupID == pageModel.ConnGroupID);

            foreach (var item in group.Items)
            {
                if (!item.IsEnabled || !item.IsConnected)
                    continue;

                item.EndpointManager.Send(cmd);
            }
        }
        /// <summary>
        /// 冻结命令
        /// </summary>
        public VCommand FreezeCommand { get; set; }

        /// <summary>
        /// 冻结方法
        /// </summary>
        private void Freeze()
        {

        }

        /// <summary>
        /// 解冻命令
        /// </summary>
        public VCommand UnFreezeCommand { get; set; }

        /// <summary>
        /// 解冻方法
        /// </summary>
        private void UnFreeze()
        {

        }

        #endregion





        private string upTotalTimes = "";

        /// <summary>
        /// 正计时时间
        /// </summary>
        private string upTime;

        public string UpTime
        {
            get { return upTime; }
            set
            {
                upTime = value;
                this.RaisePropertyChanged(nameof(UpTime));

                int hours = Convert.ToDateTime(upTime).Hour;
                int minutes = Convert.ToDateTime(upTime).Minute;
                int second = Convert.ToDateTime(upTime).Second;

                upTotalTimes = string.Format("{0}.000", (second + minutes * 60 + hours * 60 * 60).ToString());
                //((second + minutes * 60 + hours * 60 * 60) * 1000).ToString();

                //if (!RadioDown||!RadioSetStart)
                //{
                if (RadioDown && RadioSetStart)
                {
                    OnTextChanged(upTotalTimes, false);
                }
                else
                {
                    OnTextChanged(upTotalTimes, true);
                }
                //}
            }
        }

        /// <summary>
        /// 倒计时时间
        /// </summary>
        private string downTime;

        private string downTotalTimes = "";
        public string DownTime
        {
            get { return downTime; }
            set
            {
                downTime = value;
                this.RaisePropertyChanged(nameof(DownTime));

                //down和
                //if (RadioDown && RadioSetStart)
                //{
                int hours = Convert.ToDateTime(downTime).Hour;
                int minutes = Convert.ToDateTime(downTime).Minute;
                int second = Convert.ToDateTime(downTime).Second;
                downTotalTimes = string.Format("{0}.000", (second + minutes * 60 + hours * 60 * 60).ToString());
                if (RadioDown && RadioSetStart)
                {
                    OnTextChanged(downTotalTimes, true);
                }
                else
                {
                    OnTextChanged(downTotalTimes, false);
                }
                //}
            }
        }

        /// <summary>
        /// 倒计时时间框是否显示
        /// </summary>
        private Visibility isStopVisibility;

        public Visibility IsStopVisibility
        {
            get { return isStopVisibility; }
            set { isStopVisibility = value; this.RaisePropertyChanged(nameof(IsStopVisibility)); }
        }


        /// <summary>
        /// 是否显示倒计时时间
        /// </summary>
        private bool stopIsCheck = true;
        public bool StopIsCheck
        {
            get { return stopIsCheck; }
            set
            {
                stopIsCheck = value;
                this.RaisePropertyChanged(nameof(StopIsCheck));

                string showValue = "";

                if (stopIsCheck)
                {
                    IsStopVisibility = Visibility.Visible;
                }
                else
                {
                    IsStopVisibility = Visibility.Hidden;
                }

                //设置开始命令行
                if (radioSetStart)
                {

                    if (RadioDown)
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "DOWN,START,UPDATE_TEXT SET 1 "
                                    );
                            //*TIME SET {upValue},*LIMIT SET {downValue},*DIRECTION SET {cmd}"
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "DOWN,START,UPDATE_TEXT SET 1 "
                                    );

                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";

                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "UP,START,UPDATE_TEXT SET 1 "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "UP,START,UPDATE_TEXT SET 1 "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                    }

                    this.ControlField.Value = showValue;
                }

                //设置终止命令行
                else if (radioSetStop)
                {

                    if (RadioDown)
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "DOWN,STOP "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,STOP";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "DOWN,STOP "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,STOP";
                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                ApplicationDomainEx.PreviewConn,
                                ApplicationDomainEx.CurrentPage.GetVizScene(),
                                this.ControlObject.TreeNodePath,
                                this.ControlField.FieldIdentifier,
                                upTotalTimes, downTotalTimes, "UP,STOP "
                                );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,STOP";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                ApplicationDomainEx.PreviewConn,
                                ApplicationDomainEx.CurrentPage.GetVizScene(),
                                this.ControlObject.TreeNodePath,
                                this.ControlField.FieldIdentifier,
                                upTotalTimes, "NONE", "UP,STOP "
                                 );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,STOP";
                        }
                    }
                    this.ControlField.Value = showValue;
                }

            }
        }

        /// <summary>
        /// 正计时操作
        /// </summary>
        private bool radioUP;
        public bool RadioUP
        {
            get { return radioUP; }
            set
            {
                radioUP = value;
                this.RaisePropertyChanged(nameof(RadioUP));

                if (this.ControlObject == null || this.ControlField == null)
                    return;
                //正计时发送命令行
                this.VizCommandControlObjectService.SetControlObjectValue(
                            ApplicationDomainEx.PreviewConn,
                            ApplicationDomainEx.CurrentPage.GetVizScene(),
                            this.ControlObject.TreeNodePath,
                            this.ControlField.FieldIdentifier,
                            "");

                if (radioUP)
                {
                    RadioDown = false;
                    Save();
                }

                if (radioUP && RadioSetStart)
                {
                    if (!string.IsNullOrEmpty(downTotalTimes))
                    {
                        OnTextChanged(downTotalTimes, true);
                    }
                }

            }
        }

        /// <summary>
        /// 字段保存
        /// </summary>
        private void Save()
        {
            ClockFieldEntity clockFieldEntity = ApplicationDomainEx.ClockField;
            clockFieldEntity.RadioDown = this.radioDown;
            clockFieldEntity.RadioUp = this.RadioUP;
            ApplicationDomainEx.LocalDbContext.ClockField.Upsert(clockFieldEntity);
        }

        /// <summary>
        /// 倒计时操作
        /// </summary>
        private bool radioDown;
        public bool RadioDown
        {
            get { return radioDown; }
            set
            {
                radioDown = value;
                this.RaisePropertyChanged(nameof(RadioDown));

                if (this.ControlObject == null || this.ControlField == null)
                    return;

                if (radioDown)
                {
                    RadioUP = false;
                    Save();
                }
                //倒计时发送命令行
                if (radioDown)
                {
                    this.VizCommandControlObjectService.SetControlObjectValue(
                        ApplicationDomainEx.PreviewConn,
                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                        this.ControlObject.TreeNodePath,
                        this.ControlField.FieldIdentifier,
                        "");
                }



                if (radioDown && RadioSetStart)
                {
                    if (!string.IsNullOrEmpty(upTotalTimes))
                    {
                        OnTextChanged(upTotalTimes, true);
                    }
                }
            }
        }

        /// <summary>
        /// none设置命令
        /// </summary>
        private bool radioNone = true;

        public bool RadioNone
        {
            get { return radioNone; }
            set
            {
                radioNone = value;
                this.RaisePropertyChanged(nameof(RadioNone));

                if (radioNone)
                {
                    this.VizCommandControlObjectService.SetControlObjectValue(
                            ApplicationDomainEx.PreviewConn,
                            ApplicationDomainEx.CurrentPage.GetVizScene(),
                            this.ControlObject.TreeNodePath,
                            this.ControlField.FieldIdentifier,
                            "");
                    this.ControlField.Value = "";

                    RadioSetStart = false;
                    RadioSetStop = false;
                    RadioStop = false;
                    RadioContinue = false;
                    RadioFreeze = false;
                    RadioUnFreeze = false;


                }
            }
        }


        /// <summary>
        /// SetStart设置命令
        /// </summary>
        private bool radioSetStart;

        public bool RadioSetStart
        {
            get { return radioSetStart; }
            set
            {
                radioSetStart = value;
                this.RaisePropertyChanged(nameof(RadioSetStart));

                string showValue = "";

                if (radioSetStart)
                {

                    RadioNone = false;
                    RadioSetStop = false;
                    RadioStop = false;
                    RadioContinue = false;
                    RadioFreeze = false;
                    RadioUnFreeze = false;

                    if (RadioDown)
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "DOWN,START,UPDATE_TEXT SET 1 "
                                    );
                            //*TIME SET {upValue},*LIMIT SET {downValue},*DIRECTION SET {cmd}"
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "DOWN,START,UPDATE_TEXT SET 1 "
                                    );

                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";

                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "UP,START,UPDATE_TEXT SET 1 "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "UP,START,UPDATE_TEXT SET 1 "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                    }

                    this.ControlField.Value = showValue;
                }
            }
        }


        /// <summary>
        /// SetStop停止命令
        /// </summary>
        private bool radioSetStop;

        public bool RadioSetStop
        {
            get { return radioSetStop; }
            set
            {
                radioSetStop = value;
                this.RaisePropertyChanged(nameof(RadioSetStop));

                string showValue = "";
                if (radioSetStop)
                {
                    RadioNone = false;
                    RadioSetStart = false;
                    RadioStop = false;
                    RadioContinue = false;
                    RadioFreeze = false;
                    RadioUnFreeze = false;

                    if (RadioDown)
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, downTotalTimes, "DOWN,STOP "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,STOP";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    upTotalTimes, "NONE", "DOWN,STOP "
                                    );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,STOP";
                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                ApplicationDomainEx.PreviewConn,
                                ApplicationDomainEx.CurrentPage.GetVizScene(),
                                this.ControlObject.TreeNodePath,
                                this.ControlField.FieldIdentifier,
                                upTotalTimes, downTotalTimes, "UP,STOP "
                                );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,STOP";
                        }
                        else
                        {
                            this.VizCommandControlObjectService.SetControlObjectClockCmd(
                                ApplicationDomainEx.PreviewConn,
                                ApplicationDomainEx.CurrentPage.GetVizScene(),
                                this.ControlObject.TreeNodePath,
                                this.ControlField.FieldIdentifier,
                                upTotalTimes, "NONE", "UP,STOP "
                                 );
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,STOP";
                        }
                    }
                    this.ControlField.Value = showValue;
                }
            }
        }

        /// <summary>
        /// Stop命令停止
        /// </summary>

        private bool radioStop;

        public bool RadioStop
        {
            get { return radioStop; }
            set
            {
                radioStop = value;
                this.RaisePropertyChanged(nameof(RadioStop));

                if (radioStop)
                {

                    RadioNone = false;
                    RadioSetStart = false;
                    RadioSetStop = false;
                    RadioContinue = false;
                    RadioFreeze = false;
                    RadioUnFreeze = false;

                    this.VizCommandControlObjectService.SetControlObjectValue(
                        ApplicationDomainEx.PreviewConn,
                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                        this.ControlObject.TreeNodePath,
                        this.ControlField.FieldIdentifier,
                        "STOP");
                    this.ControlField.Value = "STOP";
                }
            }
        }

        /// <summary>
        /// Continue命令
        /// </summary>
        private bool radioContinue;
        public bool RadioContinue
        {
            get { return radioContinue; }
            set
            {


                radioContinue = value;
                this.RaisePropertyChanged(nameof(RadioContinue));

                if (radioContinue)
                {

                    RadioNone = false;
                    RadioSetStart = false;
                    RadioSetStop = false;
                    RadioStop = false;
                    RadioFreeze = false;
                    RadioUnFreeze = false;

                    this.VizCommandControlObjectService.SetControlObjectValue(
                        ApplicationDomainEx.PreviewConn,
                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                        this.ControlObject.TreeNodePath,
                        this.ControlField.FieldIdentifier,
                        "CONT");

                    this.ControlField.Value = "CONT";

                }
            }
        }


        /// <summary>
        /// Freeze冻结命令
        /// </summary>
        private bool radioFreeze;

        public bool RadioFreeze
        {
            get { return radioFreeze; }
            set
            {
                radioFreeze = value;
                this.RaisePropertyChanged(nameof(RadioFreeze));
                if (radioFreeze)
                {
                    RadioNone = false;
                    RadioSetStart = false;
                    RadioSetStop = false;
                    RadioStop = false;
                    RadioContinue = false;
                    RadioUnFreeze = false;

                    this.VizCommandControlObjectService.SetControlObjectValue(
                        ApplicationDomainEx.PreviewConn,
                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                        this.ControlObject.TreeNodePath,
                        this.ControlField.FieldIdentifier,
                        "UPDATE_TEXT SET 0");
                    this.ControlField.Value = "UPDATE_TEXT SET 0";

                }
            }
        }


        /// <summary>
        /// UnFreeze 解冻命令
        /// </summary>
        private bool radioUnFreeze;

        public bool RadioUnFreeze
        {
            get { return radioUnFreeze; }
            set
            {
                radioUnFreeze = value;
                this.RaisePropertyChanged(nameof(RadioUnFreeze));

                if (radioUnFreeze)
                {

                    RadioNone = false;
                    RadioSetStart = false;
                    RadioSetStop = false;
                    RadioStop = false;
                    RadioContinue = false;
                    RadioFreeze = false;


                    this.VizCommandControlObjectService.SetControlObjectValue(
                        ApplicationDomainEx.PreviewConn,
                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                        this.ControlObject.TreeNodePath,
                        this.ControlField.FieldIdentifier,
                        "UPDATE_TEXT SET 1");
                    this.ControlField.Value = "UPDATE_TEXT SET 1";
                }
            }

        }


        /// <summary>
        /// 更新数值的
        /// </summary>
        /// <param name="controlObject"></param>
        /// <param name="controlField"></param>
        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            string value = controlField?.Value;

            if (value == null) return;

            //if (value.Contains("SET DOWN"))
            //{
            //    RadioDown = true;
            //}
            //else if(value.Contains("SET UP"))
            //{
            //    RadioUP = true;
            //}

            string[] splitValues = value.Split(',');


            //*TIME SET 121.000
            //*LIMIT SET 0.000

            //设置down

            if (splitValues.Length > 1)
            {
                if (splitValues[1].Contains("*LIMIT SET"))
                {
                    string[] downVlues = splitValues[1].Split(' ');
                    double downSecond = 0;
                    if (Double.TryParse(downVlues[2], out downSecond))
                    {
                        downTotalTimes = downVlues[2];
                        //downSecond = Convert.ToDouble(downVlues[2]);
                        TimeSpan ts = new TimeSpan(0, 0, Convert.ToInt32(downSecond));
                        DownTime = ts.ToString();
                    }
                    else
                    {
                        TimeSpan ts = new TimeSpan(0, 0, 0);
                        DownTime = ts.ToString();
                    }
                }
                else
                {
                    TimeSpan ts = new TimeSpan(0, 0, 0);
                    DownTime = ts.ToString();
                }
            }
            else
            {
                TimeSpan ts = new TimeSpan(0, 0, 0);
                DownTime = ts.ToString();
            }

            //设置时间
            if (splitValues[0].Contains("*TIME SET"))
            {
                double upsecond = 0;
                string[] upValues = splitValues[0].Split(' ');
                if (Double.TryParse(upValues[2], out upsecond))
                {
                    upTotalTimes = upValues[2];
                    upsecond = Convert.ToDouble(upValues[2]);
                    TimeSpan ts = new TimeSpan(0, 0, Convert.ToInt32(upsecond));
                    UpTime = ts.ToString();
                }
                else
                {
                    TimeSpan ts = new TimeSpan(0, 0, 0);
                    UpTime = ts.ToString();
                }

            }
            else
            {
                TimeSpan ts = new TimeSpan(0, 0, 0);
                UpTime = ts.ToString();
            }

        }




        /// <summary>
        /// 文本值改变时触发
        /// </summary>
        private void OnTextChanged(string times, bool flag)
        {
            // 不需要向预览发送值
            if (!this.IsSendToPreview)
                return;

            // 没有预览连接
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            // 没有控制对象或控制字段
            if (this.ControlObject == null || this.ControlField == null)
                return;

            string showValue = "";
            // 正常模式编辑
            if (this.FieldEditMode == FieldEditMode.Normal)
            {
                //this.ControlField.Value = times;
                if (RadioSetStop)//设置的Set and stop
                {
                    if (RadioUP)//向上计时的按
                    {
                        if (StopIsCheck)
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,STOP";
                        }
                        else
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,STOP";
                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,STOP";
                        }
                        else
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,STOP";
                        }
                    }
                    this.ControlField.Value = showValue;
                }
                else if (RadioSetStart)// 设置的Set and Start
                {
                    if (RadioUP)
                    {
                        if (StopIsCheck)
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET UP,START,UPDATE_TEXT SET 1";
                        }
                    }
                    else
                    {
                        if (StopIsCheck)
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET {downTotalTimes},*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";
                        }
                        else
                        {
                            showValue = $"*TIME SET {upTotalTimes},*LIMIT SET NONE,*DIRECTION SET DOWN,START,UPDATE_TEXT SET 1";
                        }
                    }
                    this.ControlField.Value = showValue;
                }
                else if (RadioNone)
                {
                    this.ControlField.Value = "";
                }

                if (flag)
                {
                    if (!this.ControlField.IsCustom)
                    {
                        this.VizCommandControlObjectService.SetControlObjectValue(
                                        ApplicationDomainEx.PreviewConn,
                                        ApplicationDomainEx.CurrentPage.GetVizScene(),
                                        this.ControlObject.TreeNodePath,
                                        this.ControlField.FieldIdentifier,
                                       $"*TIME SET {times}");


                    }
                    else
                    {
                        this.VizCommandControlObjectService.SetCustomControlFieldValue(ApplicationDomainEx.PreviewConn, new List<ControlFieldNodeModel> { this.ControlField });
                    }
                }

                return;
            }

            // 没有列信息或行数据
            if (this.ColumnDefinition == null || this.Row == null)
                return;

            // 动态模式编辑
            if (this.FieldEditMode == FieldEditMode.Dynamic)
            {
                IDictionary<string, object> dic = this.Row as IDictionary<string, object>;
                dic[this.ColumnDefinition.FieldName] = times;

                this.ListCellEdit.UpdateEditValue(this.ColumnDefinition, this.RowHandle, this.Row);

                return;
            }
        }

    }
}
