﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 资源编辑面板模型基类
    /// </summary>
    public abstract class ResourceEditPanelModelBase : EditPanelModelBase
    {
        public ResourceEditPanelModelBase()
        {
            // GH资源
            this.GHResourceEditPartModel = new GHResourceEditPartModel();
            this.GHResourceEditPartModel.OwnerViewModel = this;

            // 媒资库

            this.MHResourceEditPartModel = new MHResourceEditPartModel();
            this.MHResourceEditPartModel.OwnerViewModel = this;
            this.MHResourceEditPartModel.VisibilityReCycle = System.Windows.Visibility.Collapsed;

            // 本地资源
        }

        #region GHResourceEditPartModel -- GH资源编辑部分模型

        private GHResourceEditPartModel ghResourceEditPartModel;
        /// <summary>
        /// GH资源编辑部分模型
        /// </summary>
        public GHResourceEditPartModel GHResourceEditPartModel
        {
            get { return ghResourceEditPartModel; }
            set { ghResourceEditPartModel = value; this.RaisePropertyChanged(nameof(GHResourceEditPartModel)); }
        }

        /// <summary>
        /// 媒体库部分编辑
        /// </summary>

        private MHResourceEditPartModel mhResourceEditPartModel;


        public MHResourceEditPartModel MHResourceEditPartModel
        {
            get { return mhResourceEditPartModel; }
            set { mhResourceEditPartModel = value; this.RaisePropertyChanged(nameof(MHResourceEditPartModel)); }
        }



        #region IShowMedia ---是否显示媒体资源库页签

        private Visibility iShowMedia = Visibility.Visible;

        /// <summary>
        /// 是否隐藏媒体资源库页签
        /// </summary>
        public Visibility IShowMedia
        {
            get { return iShowMedia; }
            set
            {
                iShowMedia = value;
                this.RaisePropertyChanged(nameof(IShowMedia));
            }
        }

        public void IsHideMedieTab()
        {
            bool flag = ApplicationDomainEx.IniStorage.GetValue<LogConfig, bool>(p => p.ISSHOWMEDIATAB);

            if (flag)
            {
                IShowMedia = Visibility.Visible;
            }
            else
            {
                IShowMedia = Visibility.Hidden;
            }
        }

        #endregion
        #endregion
    }
}
