﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 底飞编辑面板单元格模板选择器
    /// </summary>
    public class ScrollElementEditPanelCellTemplateSelector : DataTemplateSelector
    {
        /// <summary>
        /// 索引模板
        /// </summary>
        public DataTemplate IndexTemplate { get; set; }

        /// <summary>
        /// 文本模板
        /// </summary>
        public DataTemplate TextDataTemplate { get; set; }

        /// <summary>
        /// 富文本模板
        /// </summary>
        public DataTemplate RichTextDataTemplate { get; set; }

        /// <summary>
        /// 图片模板
        /// </summary>
        public DataTemplate ImageDataTemplate { get; set; }

        /// <summary>
        /// 筛选模板
        /// </summary>
        /// <param name="item">项</param>
        /// <param name="container">容器</param>
        /// <returns>数据模板</returns>
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            GridCellData data = (GridCellData)item;
            GridColumnScrollElementFieldDefinition definition = data.Column.DataContext as GridColumnScrollElementFieldDefinition;

            if (definition == null)
                return null;

            switch (definition.Type)
            {
                case VizControlFieldType.none: return null;
                case VizControlFieldType.system_index: return this.IndexTemplate;
                case VizControlFieldType.text: return this.TextDataTemplate;
                case VizControlFieldType.richtext: return this.RichTextDataTemplate;
                case VizControlFieldType.image: return this.ImageDataTemplate;
                default: return null;
            }
        }
    }
}