﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// GH场景视图模型
    /// </summary>
    public class GHSceneViewModel : GHResourcePanelModel
    {
        public GHSceneViewModel()
        {
            this.FilterResourceFileType = ResourceFileType.SCENE;

            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.AddSceneTemplateCommand = new VCommand(this.AddSceneTemplate);
        }

        // ===========================================================================
        // Command
        // ===========================================================================

        #region AddSceneTemplateCommand -- 添加场景模板命令

        /// <summary>
        /// 添加场景模板命令
        /// </summary>
        public VCommand AddSceneTemplateCommand { get; set; }

        /// <summary>
        /// 添加场景模板
        /// </summary>
        private void AddSceneTemplate()
        {
            if (this.SelectedFolderModel == null || this.SelectedFileModels.Count == 0)
            {
                DXMessageBox.Show("请选择场景模板");

                return;
            }

            if(ApplicationDomainEx.ProjectDbContext==null)
            {
                DXMessageBox.Show("请先创建项目文件或者打开项目文件");
                return;
            }

            IPageTemplateService service = ApplicationDomainEx.ServiceManager.GetService<IPageTemplateService>(ViewServiceKeys.PAGE_TEMPLATE_SERVICE);
            if (service == null)
                return;

            service.AddSceneTemplate(this.SelectedFileModels.ToList());
        }

        #endregion
    }
}
