﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// 连接服务
    /// </summary>
    public class ConnService
    {
        /// <summary>
        /// 加载包装连接分组
        /// </summary>
        /// <returns>包装连接分组</returns>
        public List<ConnGroupModel> LoadGroups()
        {
            List<ConnGroupModel> groups = new List<ConnGroupModel>();

            foreach (ConnGroupEntity entity in ApplicationDomainEx.LocalDbContext.ConnGroup.FindAll())
            {
                ConnGroupModel model = new ConnGroupModel();
                model.GroupID = entity.GroupID;
                model.IsEnabled = entity.IsEnabled;
                model.IsDefault = entity.IsDefault;
                model.Name = entity.Name;
                model.EngineType = entity.EngineType;
                model.CleanScreen = entity.CleanScreen;

                groups.Add(model);
            }

            Dictionary<Guid, ConnGroupModel> dic = groups.ToDictionary(p => p.GroupID, p => p);

            foreach (ConnEntity entity in ApplicationDomainEx.LocalDbContext.Conn.FindAll())
            {
                if (!dic.TryGetValue(entity.GroupID, out ConnGroupModel group))
                    continue;

                ConnModel model = new ConnModel();
                model.ConnID = entity.ConnID;
                model.GroupID = entity.GroupID;
                model.IP = entity.IP;
                model.Port = entity.Port;
                model.Remark = entity.Remark;
                model.IsEnabled = entity.IsEnabled;

                group.Items.Add(model);
            }

            return groups;
        }

        /// <summary>
        /// 保存包装连接分组集合
        /// </summary>
        /// <param name="groups">分组集合</param>
        public void SaveGroups(IList<ConnGroupModel> groups)
        {
            List<ConnGroupEntity> groupList = new List<ConnGroupEntity>();
            List<ConnEntity> itemList = new List<ConnEntity>();

            foreach (ConnGroupModel group in groups)
            {
                ConnGroupEntity groupEntity = new ConnGroupEntity();
                groupEntity.GroupID = group.GroupID;
                groupEntity.IsEnabled = group.IsEnabled;
                groupEntity.IsDefault = group.IsDefault;
                groupEntity.Name = group.Name;
                groupEntity.EngineType = group.EngineType;
                groupEntity.CleanScreen=group.CleanScreen;  

                groupList.Add(groupEntity);

                foreach (ConnModel item in group.Items)
                {
                    ConnEntity itemEntity = new ConnEntity();
                    itemEntity.ConnID = item.ConnID;
                    itemEntity.GroupID = item.GroupID;
                    itemEntity.IP = item.IP;
                    itemEntity.Port = item.Port;
                    itemEntity.Remark = item.Remark;
                    itemEntity.IsEnabled = item.IsEnabled;

                    itemList.Add(itemEntity);
                }
            }

            ApplicationDomainEx.LocalDbContext.ConnGroup.DeleteAll();
            ApplicationDomainEx.LocalDbContext.Conn.DeleteAll();
            ApplicationDomainEx.LocalDbContext.ConnGroup.Insert(groupList);
            ApplicationDomainEx.LocalDbContext.Conn.Insert(itemList);
        }
    }
}
