﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 连接分组实体
    /// </summary>
    public class ConnGroupEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType { get; set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled { get; set; }

        /// <summary>
        /// 是否是默认分组
        /// </summary>
        public bool IsDefault { get; set; }

        /// <summary>
        /// 是否清屏
        /// </summary>
        public bool CleanScreen { get; set; }
    }
}
