﻿using System;
using System.Collections.Generic;
using System.Data.SqlTypes;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 控制对象列节点
    /// </summary>
    public class ControlObject_Field_node : IXmlSerialize
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 类型
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 位置
        /// </summary>
        public string Location { get; set; }

        /// <summary>
        /// 定义
        /// </summary>
        public ControlObject_Schema_Node Schema { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            this.Name = element.GetAttributeValue<string>("name");
            this.Type = element.GetAttributeValue<string>("type");
            this.Description = element.GetAttributeValue<string>("description");
            this.Location = element.GetAttributeValue<string>("location");

            var schema = element.Element("schema");
            if (schema == null)
                return;

            this.Schema = new ControlObject_Schema_Node();
            this.Schema.FromXmlElement(schema);
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            XElement entry = new XElement("field");
            entry.SetAttributeValueIfValueNotNull("name", this.Name);
            entry.SetAttributeValueIfValueNotNull("type", this.Type);
            entry.SetAttributeValueIfValueNotNull("description", this.Description);
            entry.SetAttributeValueIfValueNotNull("location", this.Location);

            return entry;
        }
    }
}
