﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using VIZ.Framework.Module;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package
{
    /// <summary>
    /// Interaction logic for LoginWindow.xaml
    /// </summary>
    public partial class LoginWindow : ThemedWindow
    {
        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public LoginWindow()
        {
            InitializeComponent();

            this.Closed += MainWindow_Closed;
        }

        /// <summary>
        /// 关闭窗口
        /// </summary>
        private void MainWindow_Closed(object sender, EventArgs e)
        {
            // 记录操作日志
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, Storage.RecordLogOperate.Operate, Storage.RecordLogTrigger.Human, RecordLogConstants.OPERATE_SHUTDOWN);

            // 启动结束流程
            AppSetup.ShutDown();

            // 结束进程
            Environment.Exit(0);
        }
    }
}
