﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 列控制字段定义
    /// </summary>
    public class GridColumnControlFieldDefinition : GridColumnDefinition
    {
        #region Type -- 字段类型

        private VizControlFieldType type;
        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlFieldType Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion

        #region ControlObject -- 控制对象

        private ControlObjectModel controlObject;
        /// <summary>
        /// 控制对象
        /// </summary>
        public ControlObjectModel ControlObject
        {
            get { return controlObject; }
            set { controlObject = value; this.RaisePropertyChanged(nameof(ControlObject)); }
        }

        #endregion

        #region ControlField -- 控制字段

        private ControlFieldNodeModel controlField;
        /// <summary>
        /// 控制字段
        /// </summary>
        public ControlFieldNodeModel ControlField
        {
            get { return controlField; }
            set { controlField = value; this.RaisePropertyChanged(nameof(ControlField)); }
        }

        #endregion
    }
}
