﻿using DevExpress.Xpf.Editors.Settings;
using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 列定义
    /// </summary>
    public class GridColumnDefinition : ModelBase
    {
        // ==================================================================
        // 列属性
        // ==================================================================

        #region ColumnKey -- 列键

        private string columnKey;
        /// <summary>
        /// 列键
        /// </summary>
        public string ColumnKey
        {
            get { return columnKey; }
            set { columnKey = value; this.RaisePropertyChanged(nameof(ColumnKey)); }
        }

        #endregion

        #region FieldName -- 绑定字段

        private string fieldName;
        /// <summary>
        /// 绑定字段
        /// </summary>
        public string FieldName
        {
            get { return fieldName; }
            set { fieldName = value; this.RaisePropertyChanged(nameof(FieldName)); }
        }

        #endregion

        #region Header -- 头部

        private object header;
        /// <summary>
        /// 头部
        /// </summary>
        public object Header
        {
            get { return header; }
            set { header = value; this.RaisePropertyChanged(nameof(Header)); }
        }

        #endregion

        #region ReadOnly -- 是否只读

        private bool readOnly;
        /// <summary>
        /// 是否只读
        /// </summary>
        public bool ReadOnly
        {
            get { return readOnly; }
            set { readOnly = value; this.RaisePropertyChanged(nameof(ReadOnly)); }
        }

        #endregion

        #region Width -- 宽度

        private GridColumnWidth width = new GridColumnWidth(1, GridColumnUnitType.Auto);
        /// <summary>
        /// 宽度
        /// </summary>
        public GridColumnWidth Width
        {
            get { return width; }
            set { width = value; this.RaisePropertyChanged(nameof(Width)); }
        }

        #endregion

        #region MinWidth -- 最小宽度

        private double minWidth = 10d;
        /// <summary>
        /// 最小宽度
        /// </summary>
        public double MinWidth
        {
            get { return minWidth; }
            set { minWidth = value; this.RaisePropertyChanged(nameof(MinWidth)); }
        }

        #endregion

        #region MaxWidth -- 最大宽度

        private double maxWidth = 500d;
        /// <summary>
        /// 最大宽度
        /// </summary>
        public double MaxWidth
        {
            get { return maxWidth; }
            set { maxWidth = value; this.RaisePropertyChanged(nameof(MaxWidth)); }
        }

        #endregion

        #region AllowEditing -- 是否启用编辑

        private bool allowEditing;
        /// <summary>
        /// 是否启用编辑
        /// </summary>
        public bool AllowEditing
        {
            get { return allowEditing; }
            set { allowEditing = value; this.RaisePropertyChanged(nameof(AllowEditing)); }
        }

        #endregion

        #region AllowSorting -- 是否启用排序

        private bool allowSorting;
        /// <summary>
        /// 是否启用排序
        /// </summary>
        public bool AllowSorting
        {
            get { return allowSorting; }
            set { allowSorting = value; this.RaisePropertyChanged(nameof(AllowSorting)); }
        }

        #endregion

        #region AllowResizing -- 是否支持改变大小

        private bool allowResizing;
        /// <summary>
        /// 是否支持改变大小
        /// </summary>
        public bool AllowResizing
        {
            get { return allowResizing; }
            set { allowResizing = value; this.RaisePropertyChanged(nameof(AllowResizing)); }
        }

        #endregion

        #region Visible -- 是否可见

        private bool visible = true;
        /// <summary>
        /// 是否可见
        /// </summary>
        public bool Visible
        {
            get { return visible; }
            set { visible = value; this.RaisePropertyChanged(nameof(Visible)); }
        }

        #endregion

        #region VisibleIndex -- 排序

        private int visibleIndex;
        /// <summary>
        /// 排序
        /// </summary>
        public int VisibleIndex
        {
            get { return visibleIndex; }
            set { visibleIndex = value; this.RaisePropertyChanged(nameof(VisibleIndex)); }
        }

        #endregion
    }
}
