﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 页模型基类
    /// </summary>
    public abstract class PageModelBase : ModelBase
    {
        #region Scene -- 场景

        private string scene;
        /// <summary>
        /// 场景
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        #region ScenePath -- 场景路径

        private string scenePath;
        /// <summary>
        /// 场景路径
        /// </summary>
        public string ScenePath
        {
            get { return scenePath; }
            set { scenePath = value; this.RaisePropertyChanged(nameof(ScenePath)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Layer -- 包装层

        private VizLayer layer = VizLayer.MAIN_LAYER;
        /// <summary>
        /// 包装层
        /// </summary>
        public VizLayer Layer
        {
            get { return layer; }
            set { layer = value; this.RaisePropertyChanged(nameof(Layer)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private EngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }

        #endregion

        #region PageType -- 页类型

        private PageType pageType;
        /// <summary>
        /// 页类型
        /// </summary>
        public PageType PageType
        {
            get { return pageType; }
            set { pageType = value; this.RaisePropertyChanged(nameof(PageType)); }
        }

        #endregion

        #region Order -- 排序索引

        private int order;
        /// <summary>
        /// 排序索引
        /// </summary>
        public int Order
        {
            get { return order; }
            set { order = value; this.RaisePropertyChanged(nameof(Order)); }
        }

        #endregion

        #region ThumbnailBitmap -- 缩略图

        private Bitmap thumbnailBitmap;
        /// <summary>
        /// 缩略图
        /// </summary>
        public Bitmap ThumbnailBitmap
        {
            get { return thumbnailBitmap; }
            set { thumbnailBitmap = value; this.RaisePropertyChanged(nameof(ThumbnailBitmap)); }
        }

        #endregion

        // -------------------------------------------------------------------
        // 切换逻辑

        #region TransitionLogic -- 是否为切换逻辑层

        private bool transitionLogic;
        /// <summary>
        /// 是否为切换逻辑层
        /// </summary>
        public bool TransitionLogic
        {
            get { return transitionLogic; }
            set { transitionLogic = value; this.RaisePropertyChanged(nameof(TransitionLogic)); }
        }

        #endregion

        #region LayerIdentifier -- 切换逻辑层名

        private string layerIdentifier;
        /// <summary>
        /// 切换逻辑层名
        /// </summary>
        public string LayerIdentifier
        {
            get { return layerIdentifier; }
            set { layerIdentifier = value; this.RaisePropertyChanged(nameof(LayerIdentifier)); }
        }

        #endregion

        #region StateIdentifier -- 进入方式

        private string stateIdentifier;
        /// <summary>
        /// 进入方式
        /// </summary>
        public string StateIdentifier
        {
            get { return stateIdentifier; }
            set { stateIdentifier = value; this.RaisePropertyChanged(nameof(StateIdentifier)); }
        }

        #endregion

        #region BackgroundScene -- 背景层

        private string backgroundScene;
        /// <summary>
        /// 背景层
        /// </summary>
        public string BackgroundScene
        {
            get { return backgroundScene; }
            set { backgroundScene = value; }
        }

        #endregion

        // =========================================================
        // 扩展属性
        // =========================================================

        #region IsOpen -- 是否是当前打开页

        private bool isOpen;
        /// <summary>
        /// 是否是当前打开页
        /// </summary>
        public bool IsOpen
        {
            get { return isOpen; }
            set { isOpen = value; this.RaisePropertyChanged(nameof(IsOpen)); }
        }

        #endregion

        #region IsTake -- 是否上板

        private bool isTake;
        /// <summary>
        /// 是否上板
        /// </summary>
        public bool IsTake
        {
            get { return isTake; }
            set { isTake = value; this.RaisePropertyChanged(nameof(IsTake)); }
        }

        #endregion
    }
}
