﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    public class MHResourceFolderModel : ResourceFolderModelBase
    {
        /// <summary>
        /// GH 节点
        /// </summary>
        public GH_Entry_Node EntryNode { get; set; }

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set { path = value; this.RaisePropertyChanged(nameof(Path)); }
        }

        #endregion

        #region Files -- 文件集合

        private ObservableCollection<MHResourceFileModel> files;
        /// <summary>
        /// 文件集合
        /// </summary>
        public ObservableCollection<MHResourceFileModel> Files
        {
            get { return files; }
            set { files = value; this.RaisePropertyChanged(nameof(Files)); }
        }

        #endregion
    }
}
