﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 场景信息模型
    /// </summary>
    public class SceneInfoModel : ModelBase
    {
        #region ConnGroupID -- 所属连接ID

        private Guid connGroupID;
        /// <summary>
        /// 所属连接ID
        /// </summary>
        public Guid ConnGroupID
        {
            get { return connGroupID; }
            set { connGroupID = value; this.RaisePropertyChanged(nameof(ConnGroupID)); }
        }

        #endregion

        #region Scene -- 场景名

        private string scene;
        /// <summary>
        /// 场景名
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        #region ScenePath -- 场景路径

        private string scenePath;
        /// <summary>
        /// 场景路径
        /// </summary>
        public string ScenePath
        {
            get { return scenePath; }
            set { scenePath = value; this.RaisePropertyChanged(nameof(ScenePath)); }
        }

        #endregion

        #region TakeInitedProgress -- 远端初始化进度（0 - 1）

        private double takeInitedProgress;
        /// <summary>
        ///  远端初始化进度（0 - 1）
        /// </summary>
        public double TakeInitedProgress
        {
            get { return takeInitedProgress; }
            set { takeInitedProgress = value; this.RaisePropertyChanged(nameof(TakeInitedProgress)); }
        }

        #endregion

        #region TakeInitedMessage -- 远端初始化消息

        private string takeInitedMessage;
        /// <summary>
        /// 远端初始化消息
        /// </summary>
        public string TakeInitedMessage
        {
            get { return takeInitedMessage; }
            set { takeInitedMessage = value; this.RaisePropertyChanged(nameof(TakeInitedMessage)); }
        }

        #endregion
    }
}