﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 操作日志常量
    /// </summary>
    public static class RecordLogConstants
    {
        // ===============================================================================================
        // 系统
        // ===============================================================================================

        /// <summary>
        /// 系统启动
        /// </summary>
        public const string SYSTEM_SET_UP = "系统启动";

        /// <summary>
        /// 启动预览
        /// </summary>
        public const string SYSTEM_SET_UP_PREVIEW = "启动预览";

        /// <summary>
        /// 发送Viz命令
        /// </summary>
        public const string SYSTEM_SEND_VIZ_COMMAND = "发送Viz命令";

        /// <summary>
        /// 触发快捷键
        /// </summary>
        public const string SYSTEM_HOT_KEY = "触发快捷键";

        /// <summary>
        /// 页命令日志
        /// </summary>
        public const string SYSTEM_PAGE_CMD_LOG = "页命令日志";

        // =============================================================================
        // Task
        // =============================================================================

        /// <summary>
        /// 注册任务
        /// </summary>
        public const string SYSTEM_TASK_REGISTER = "注册任务";

        /// <summary>
        /// 取消任务
        /// </summary>
        public const string SYSTEM_TASK_CANCEL = "取消任务";

        /// <summary>
        /// 开始任务
        /// </summary>
        public const string SYSTEM_TASK_START = "开始任务";

        /// <summary>
        /// 停止任务
        /// </summary>
        public const string SYSTEM_TASK_STOP = "停止任务";

        // ===============================================================================================
        // 操作
        // ===============================================================================================

        /// <summary>
        /// 登录
        /// </summary>
        public const string OPERATE_LOGIN = "登录";

        /// <summary>
        /// 关闭系统
        /// </summary>
        public const string OPERATE_SHUTDOWN = "关闭系统";

        // =============================================================================
        // 设置
        // =============================================================================

        /// <summary>
        /// 打开设置页面
        /// </summary>
        public const string OPERATE_SETTING_OPEN = "打开设置页面";

        /// <summary>
        /// 重置布局
        /// </summary>
        public const string OPERATE_SETTING_RESET_LAYOUT = "重置布局";

        /// <summary>
        /// 保存设置
        /// </summary>
        public const string OPERATE_SETTING_SAVE = "保存设置";

        /// <summary>
        /// Viz连接
        /// </summary>
        public const string OPERATE_SETTING_VIZ_CONNECTION = "Viz连接";

        /// <summary>
        /// Viz连接断开
        /// </summary>
        public const string OPERATE_SETTING_VIZ_DISCONNECTION = "Viz连接断开";

        // =============================================================================
        // 项目
        // =============================================================================

        /// <summary>
        /// 创建项目
        /// </summary>
        public const string OPERATE_PROJECT_CREATE = "创建项目";

        /// <summary>
        /// 打开项目
        /// </summary>
        public const string OPERATE_PROJECT_OPEN = "打开项目";

        /// <summary>
        /// 保存项目
        /// </summary>
        public const string OPERATE_PROJECT_SAVE = "保存项目";


        /// <summary>
        /// 另存项目
        /// </summary>
        public const string OPERATE_PROJECT_SAVEAS = "另存项目";

        /// <summary>
        /// 关闭项目
        /// </summary>
        public const string OPERATE_PROJECT_CLOSE = "关闭项目";

        // =============================================================================
        // 模板
        // =============================================================================

        /// <summary>
        /// 添加模板
        /// </summary>
        public const string OPERATE_TEMPLATE_ADD = "添加模板";

        /// <summary>
        /// 打开模板
        /// </summary>
        public const string OPERATE_TEMPLATE_OPEN = "打开模板";

        /// <summary>
        /// 更新模板
        /// </summary>
        public const string OPERATE_TEMPLATE_UPDATE = "更新模板";

        /// <summary>
        /// 删除模板
        /// </summary>
        public const string OPERATE_TEMPLATE_DELETE = "删除模板";

        // =============================================================================
        // 播出单
        // =============================================================================

        /// <summary>
        /// 播出单添加分组
        /// </summary>
        public const string OPERATE_PAGE_GROUP_ADD = "播出单添加分组";

        /// <summary>
        /// 播出单重名了
        /// </summary>
        public const string OPERATE_PAGE_GROUP_RENAME = "播出单重命名";

        /// <summary>
        /// 播出单删除分组
        /// </summary>
        public const string OPERATE_PAGE_GROUP_DELETE = "播出单删除分组";

        /// <summary>
        /// 播出单删除页
        /// </summary>
        public const string OPERATE_PAGE_DELETE = "播出单删除页";

        /// <summary>
        /// 打开播出单页
        /// </summary>
        public const string OPERATE_PAGE_OPEN = "打开播出单页";

        /// <summary>
        /// 更新播出单页
        /// </summary>
        public const string OPERATE_PAGE_UPDATE = "更新播出单页";

        /// <summary>
        /// 清理页
        /// </summary>
        public const string OPERATE_PAGE_CLEAR = "清理页";

        /// <summary>
        /// 初始化页
        /// </summary>
        public const string OPERATE_PAGE_INIT = "初始化页";

        /// <summary>
        /// 拷贝播出单分组
        /// </summary>
        public const string OPERATE_PAGE_GROUP_COPY = "拷贝播出单分组";

        /// <summary>
        /// 复制页
        /// </summary>
        public const string OPERATE_PAGE_BEGIN_COPY = "复制页";

        /// <summary>
        /// 粘贴页
        /// </summary>
        public const string OPERATE_PAGE_PASTE = "粘贴页";

        /// <summary>
        /// 添加页
        /// </summary>
        public const string OPERATE_PAGE_ADD = "添加页";

        /// <summary>
        /// 添加命令模板页
        /// </summary>
        public const string OPERATE_PAGE_ADD_CMD = "添加命令模板页";

        /// <summary>
        /// 修改页号
        /// </summary>
        public const string OPERATE_PAGE_CHANGE_PAGE_NUM = "修改页号";

        // =============================================================================
        // Viz预览
        // =============================================================================

        /// <summary>
        /// 重启预览引擎
        /// </summary>
        public const string OPERATE_RESTART_PREVIEW = "重启预览引擎";

        /// <summary>
        /// 点击预览播放
        /// </summary>
        public const string OPERATE_PREVIEW_PLAY = "预览：点击播放";

        /// <summary>
        /// 点击预览继续
        /// </summary>
        public const string OPERATE_PREVIEW_CONTINUE = "预览：点击继续";

        /// <summary>
        /// 点击预览停止
        /// </summary>
        public const string OPERATE_PREVIEW_STOP = "预览：点击停止";

        /// <summary>
        /// 点击预览更新
        /// </summary>
        public const string OPERATE_PREVIEW_UPDATE = "预览：点击更新";

        /// <summary>
        /// 点击预览RGB
        /// </summary>
        public const string OPERATE_PREVIEW_RGB = "预览：点击RGB";

        /// <summary>
        /// 点击预览Key
        /// </summary>
        public const string OPERATE_PREVIEW_KEY = "预览：点击Key";

        /// <summary>
        /// 点击预览KeyPreview
        /// </summary>
        public const string OPERATE_PREVIEW_KEY_PREVIEW = "预览：点击KeyPreview";

        /// <summary>
        /// 点击预览TS
        /// </summary>
        public const string OPERATE_PREVIEW_TS = "预览：点击TS";

        /// <summary>
        /// 点击预览SA
        /// </summary>
        public const string OPERATE_PREVIEW_SA = "预览：点击SA";

        /// <summary>
        /// 点击预览BB
        /// </summary>
        public const string OPERATE_PREVIEW_BB = "预览：点击BB";

        // =============================================================================
        // Take
        // =============================================================================

        /// <summary>
        /// 点击Take
        /// </summary>
        public const string OPERATE_TAKE_TAKE = "播控：点击Take";

        /// <summary>
        /// 点击继续
        /// </summary>
        public const string OPERATE_TAKE_CONTINUE = "播控：点击Continue";

        /// <summary>
        /// 点击下版
        /// </summary>
        public const string OPERATE_TAKE_OUT = "播控：点击TakeOut";

        /// <summary>
        /// 点击更新
        /// </summary>
        public const string OPERATE_TAKE_UPDATE = "播控：点击Update";

        // =============================================================================
        // 控制对象字段编辑
        // =============================================================================

        /// <summary>
        /// 保存控制字段
        /// </summary>
        public const string OPERATE_CONTROL_FIELD_SAVE = "保存控制字段";

        /// <summary>
        /// 另存为页
        /// </summary>
        public const string OPERATE_CONTROL_FIELD_SAVE_AS = "另存为页";


        // =============================================================================
        // 媒体资源库
        // =============================================================================


        /// <summary>
        /// 刷新文件夹
        /// </summary>
        public const string OPERATE_FLODER_REFRESH = "文件夹：刷新";


        /// <summary>
        /// 文件夹创建
        /// </summary>
        public const string OPERATE_FLODER_CREATE = "文件夹:创建";

        /// <summary>
        /// 文件夹删除
        /// </summary>
        public const string OPERATE_FLODER_DELETE = "文件夹：删除";


        /// <summary>
        /// 文件夹移入文件
        /// </summary>
        public const string OPERATE_FLODER_MOVEFILE = "文件夹：移入文件";


        /// <summary>
        /// 导出文件夹文件
        /// </summary>
        public const string OPERATE_FLODER_EXPORT = "文件夹：导出文件夹文件";


        /// <summary>
        /// 文件夹双击打开
        /// </summary>
        public const string OPERATE_FLODER_EXPAND = "文件夹：文件夹双击展开";


        /// <summary>
        /// 文件刷新
        /// </summary>
        public const string OPERATE_FILE_REFRESH = "文件：刷新";

        /// <summary>
        /// 文件创建
        /// </summary>
        public const string OPERATE_FILE_CREATE = "文件：创建";

        /// <summary>
        /// 文件删除
        /// </summary>
        public const string OPERATE_FILE_DELETE = "文件：删除";

        /// <summary>
        /// 文件移动
        /// </summary>
        public const string OPERATE_FILE_MOVE = "文件：移动";


        /// <summary>
        /// 文件导出
        /// </summary>
        public const string OPERATE_FILE_EXPORT = "文件：导出";

        /// <summary>
        /// 文件列表
        /// </summary>

        public const string OPERATE_FILE_LIST = "文件：列表";

        /// <summary>
        /// 图片列表
        /// </summary>
        public const string OPERATE_FILE_IMAGELIST = "文件：图片列表";


        /// <summary>
        /// 图片名称排序
        /// </summary>
        public const string OPERATE_FILE_SORTNAME = "文件：名称排序";


        /// <summary>
        /// 文件日期排序
        /// </summary>
        public const string OPERATE_FILE_DATE = "文件：日期排序";


        /// <summary>
        /// 文件双击
        /// </summary>
        public const string OPERATE_FILE_DOUBLECLICK = "文件：双击";


        /// <summary>
        /// 文件编辑图片
        /// </summary>
        public const string OPERATE_FILE_EDITIMAGE = "文件：编辑图片";


        /// <summary>
        /// 回收站文件刷新
        /// </summary>
        public const string OPERATE_RECYCLEH_REFRESH = "回收站：文件刷新";


        /// <summary>
        /// 回收站文件还原
        /// </summary>
        public const string OPERATE_RECYCLEH_FILE = "回收站：文件还原";




    }
}
