﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using VIZ.Package.Storage;

namespace VIZ.Package.Module.Resource
{
    /// <summary>
    /// 控制字段类型字符串转化器
    /// </summary>
    public class VizControlFieldTypeStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is VizControlFieldType))
                return string.Empty;

            VizControlFieldType fieldType = (VizControlFieldType)value;

            if (fieldType == VizControlFieldType.none)
                return string.Empty;
            else
                return fieldType.ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
