﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 控制服务
    /// </summary>
    public interface IControlService : IService
    {
        /// <summary>
        /// 上板
        /// </summary>
        void Take();

        /// <summary>
        /// 上版
        /// </summary>
        /// <param name="callback">上版完成后的回调</param>
        void Take(Action callback);

        /// <summary>
        /// 当页打开后Take指定页
        /// </summary>
        /// <param name="pageBase">指定页</param>
        void TakeWhenPageOpend(PageModelBase pageBase);

        /// <summary>
        /// 当页打开后Continue指定页
        /// </summary>
        /// <param name="pageBase">指定页</param>
        void TakeContinueWhenPageOpend(PageModelBase pageBase);

        /// <summary>
        /// 当页打开后TakeOut指定页
        /// </summary>
        /// <param name="pageBase">指定页</param>
        void TakeOutWhenPageOpend(PageModelBase pageBase);

        /// <summary>
        /// 继续
        /// </summary>
        void Continue();

        /// <summary>
        /// 下版
        /// </summary>
        void TakeOut();

        /// <summary>
        /// 更新
        /// </summary>
        void Update();
    }
}
