﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页命令服务
    /// </summary>
    public interface IPageCommandService : IService
    {
        /// <summary>
        /// 开始执行上板命令
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="conn">连接</param>
        void BeginExecuteTakeCommand(PageModelBase pageBase, ConnModel conn);

        /// <summary>
        /// 开始执行继续命令
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="conn">连接</param>
        void BeginExecuteTakeContinueCommand(PageModelBase pageBase, ConnModel conn);

        /// <summary>
        /// 开始执行下板命令
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="conn">连接</param>
        void BeginExecuteTakeOutCommand(PageModelBase pageBase, ConnModel conn);

        /// <summary>
        /// 开始执行更新命令
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="conn">连接</param>
        void BeginExecuteTakeUpdateCommand(PageModelBase pageBase, ConnModel conn);
    }
}
