﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// Interaction logic for ImageEdit.xaml
    /// </summary>
    public partial class ImageEdit : UserControl
    {
        ImageEditViewModel vm = new ImageEditViewModel();
        public ImageEdit()
        {
            InitializeComponent();
            WPFHelper.BindingViewModel(this, vm);
            this.Loaded += ImageEdit_Loaded;
        }

        private void ImageEdit_Loaded(object sender, RoutedEventArgs e)
        {
            ImageDealer.BitSource = vm.OriginImage;
        }

        //private void Button_Click_1(object sender, RoutedEventArgs e)
        //{
        //    ImageDealer.CutImage();
        //}

        private void ImageDealer_OnOnCutImaging(object sender, RoutedEventArgs e)
        {
            CutImage.Source = (BitmapSource)e.OriginalSource;

            txt_Height.Text = CutImage.Source.Height.ToString();
            txt_With.Text = CutImage.Source.Width.ToString();
            vm.CutImage = vm.ImageSourceToBitmap(CutImage.Source);

        }
    }
}
