﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// Viz元素命令服务
    /// </summary>
    public class VizCommandElementService
    {
        /// <summary>
        /// 预览播放
        /// </summary>
        /// <param name="scrollElementField">底飞元素字段</param>
        public void PreviewPlay(ControlFieldNodeModel scrollElementField)
        {
            if (ApplicationDomainEx.PreviewConn == null || !ApplicationDomainEx.PreviewConn.IsConnected)
                return;

            VizConfigEntity config = ApplicationDomainEx.VizConfig;

            if (config.EngineFullType == EngineFullType.VIZ_Eng3)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"RENDERER*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*start INVOKE");
            }
            else if (config.EngineFullType == EngineFullType.VIZ_Eng4)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*start INVOKE");
            }
        }

        /// <summary>
        /// 预览继续
        /// </summary>
        /// <param name="scrollElementField">底飞元素字段</param>
        public void PreviewContinue(ControlFieldNodeModel scrollElementField)
        {
            if (ApplicationDomainEx.PreviewConn == null || !ApplicationDomainEx.PreviewConn.IsConnected)
                return;

            VizConfigEntity config = ApplicationDomainEx.VizConfig;

            if (config.EngineFullType == EngineFullType.VIZ_Eng3)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"RENDERER*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*continue INVOKE");
            }
            else if (config.EngineFullType == EngineFullType.VIZ_Eng4)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*continue INVOKE");
            }
        }

        /// <summary>
        /// 预览停止
        /// </summary>
        /// <param name="scrollElementField">底飞元素字段</param>
        public void PreviewStop(ControlFieldNodeModel scrollElementField)
        {
            if (ApplicationDomainEx.PreviewConn == null || !ApplicationDomainEx.PreviewConn.IsConnected)
                return;

            VizConfigEntity config = ApplicationDomainEx.VizConfig;

            if (config.EngineFullType == EngineFullType.VIZ_Eng3)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"RENDERER*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*stop INVOKE");
            }
            else if (config.EngineFullType == EngineFullType.VIZ_Eng4)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*stop INVOKE");
            }
        }

        /// <summary>
        /// 预览设置位置
        /// </summary>
        /// <param name="scrollElementField">底飞元素字段</param>
        /// <param name="pos">位置值</param>
        public void PreviewSetPos(ControlFieldNodeModel scrollElementField, double pos)
        {
            if (ApplicationDomainEx.PreviewConn == null || !ApplicationDomainEx.PreviewConn.IsConnected)
                return;

            VizConfigEntity config = ApplicationDomainEx.VizConfig;

            if (config.EngineFullType == EngineFullType.VIZ_Eng3)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"RENDERER*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*currentPos SET {pos}");
            }
            else if (config.EngineFullType == EngineFullType.VIZ_Eng4)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Send($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*currentPos SET {pos}");
            }
        }

        /// <summary>
        /// 预览获取位置值
        /// </summary>
        /// <param name="scrollElementField">底飞元素字段</param>
        /// <returns>位置值</returns>
        public double? PreviewGetPos(ControlFieldNodeModel scrollElementField)
        {
            if (ApplicationDomainEx.PreviewConn == null || !ApplicationDomainEx.PreviewConn.IsConnected)
                return null;


            VizConfigEntity config = ApplicationDomainEx.VizConfig;

            string result = null;
            if (config.EngineFullType == EngineFullType.VIZ_Eng3)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Request($"RENDERER*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*currentPos GET");
                result = ApplicationDomainEx.PreviewConn.EndpointManager.Request($"RENDERER*TREE*$object*FUNCTION*ControlObject**result GET");
            }
            else if (config.EngineFullType == EngineFullType.VIZ_Eng4)
            {
                ApplicationDomainEx.PreviewConn.EndpointManager.Request($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject*in SET ON_CONTAINER {scrollElementField.FieldIdentifier} GEOM*currentPos GET");
                result = ApplicationDomainEx.PreviewConn.EndpointManager.Request($"{ApplicationDomainEx.VizPreviewRenderer}*TREE*$object*FUNCTION*ControlObject**result GET");
            }

            if (string.IsNullOrWhiteSpace(result) || result.StartsWith(ApplicationConstants.VIZ_COMMAND_RESULT_ERROR_PREFIX))
                return null;

            double.TryParse(result, out double value);

            return value;
        }
    }
}
