﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.Package.TestPlugin
{
    /// <summary>
    /// TestPageView.xaml 的交互逻辑
    /// </summary>
    public partial class TestPageView : UserControl, IPluginView
    {
        public TestPageView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, new TestPageViewModel());

            this.Loaded += TestModuleView_Loaded;
        }

        private PackageTaskModel task;

        private void TestModuleView_Loaded(object sender, RoutedEventArgs e)
        {
            if (this.task != null)
                return;

            this.task = new PackageTaskModel(this);
            this.task.IsPreviewEnabled = true;
            this.task.IsTakeEnabled = true;
            this.task.IsRunning = true;
            this.task.ErrorMessage = "this is a try.";
            this.task.PreviewUpdateAction = this.OnPreviewUpdate;
            this.task.TakeUpdateAction = this.OnTakeUpdate;

            IPackageTaskService service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;

            service.Register(this.task);
        }

        private void OnPreviewUpdate(ConnModel conn)
        {
            Debug.WriteLine($"PreviewUpdate");
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            Debug.WriteLine($"TakeUpdate");
        }

        /// <summary>
        /// 上版
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakIn(ConnModel conns)
        { }

        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="conn">连接</param>
        public void TakeContinue(ConnModel conn)
        { }

        /// <summary>
        /// 下版子
        /// </summary>
        /// <param name="conn">连接</param>
        public void TakeOut(ConnModel conn)
        { }

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="conn">连接</param>
        public void TakeUpdate(ConnModel conn)
        { }

        /// <summary>
        /// 预览上版子
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewIn(ConnModel conn)
        { }

        /// <summary>
        /// 预览继续
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewContinue(ConnModel conn)
        { }

        /// <summary>
        /// 预览下版
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewOut(ConnModel conn)
        { }

        /// <summary>
        /// 预览更新
        /// </summary>
        /// <param name="conn"></param>
        public void PreviewUpdate(ConnModel conn)
        { }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        { }

        /// <summary>
        /// 打开页后触发
        /// </summary>
        /// <param name="conn">连接</param>
        /// <param name="page">页</param>
        public void PageOpend(ConnModel conn, PageModel page)
        {

        }
    }
}
