﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 文件夹模型
    /// </summary>
    public class FolderModel : ModelBase
    {
        /// <summary>
        /// 文件夹模型
        /// </summary>
        /// <param name="path">文件夹路径</param>
        public FolderModel(string path)
        {
            this.Path = path;
            this.Name = System.IO.Path.GetFileName(path);
        }

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set { path = value; this.RaisePropertyChanged(nameof(Path)); }
        }

        #endregion

        #region Parent -- 父级节点

        private FolderModel parent;
        /// <summary>
        /// 父级节点
        /// </summary>
        public FolderModel Parent
        {
            get { return parent; }
            set { parent = value; this.RaisePropertyChanged(nameof(Parent)); }
        }

        #endregion

        #region Folders -- 子文件夹集合

        private ObservableCollection<FolderModel> folders = new ObservableCollection<FolderModel>();
        /// <summary>
        /// 子文件夹集合
        /// </summary>
        public ObservableCollection<FolderModel> Folders
        {
            get { return folders; }
            set { folders = value; this.RaisePropertyChanged(nameof(Folders)); }
        }

        #endregion

        #region Files -- 文件集合

        private ObservableCollection<FileModel> files = new ObservableCollection<FileModel>();
        /// <summary>
        /// 文件集合
        /// </summary>
        public ObservableCollection<FileModel> Files
        {
            get { return files; }
            set { files = value; this.RaisePropertyChanged(nameof(Files)); }
        }

        #endregion

        // -----------------------------------------------
        // 扩展属性

        #region IsLoadedFolder -- 是否已经完成了文件夹的加载

        private bool isLoadedFolder;
        /// <summary>
        /// 是否已经完成了文件夹的加载
        /// </summary>
        public bool IsLoadedFolder
        {
            get { return isLoadedFolder; }
            set { isLoadedFolder = value; this.RaisePropertyChanged(nameof(IsLoadedFolder)); }
        }

        #endregion

        #region IsLoadedFiles -- 是否已经完成了文件的加载

        private bool isLoadedFiles;
        /// <summary>
        /// 是否已经完成了文件的加载
        /// </summary>
        public bool IsLoadedFiles
        {
            get { return isLoadedFiles; }
            set { isLoadedFiles = value; this.RaisePropertyChanged(nameof(IsLoadedFiles)); }
        }

        #endregion

        #region IsExpand -- 文件夹是否被展开

        private bool isExpand;
        /// <summary>
        /// 文件夹是否被展开
        /// </summary>
        public bool IsExpand
        {
            get { return isExpand; }
            set { isExpand = value; this.RaisePropertyChanged(nameof(IsExpand)); }
        }

        #endregion
    }
}
