﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;
using VIZ.Package.Domain;

namespace VIZ.Package.Module.Resource
{
    /// <summary>
    /// 连接分组状态 到 纯色画刷转化器
    /// </summary>
    public class ConnGroupStatus2BrushConverter : IValueConverter
    {
        /// <summary>
        /// 全断开画刷
        /// </summary>
        public SolidColorBrush AllDisconnectionBrush { get; set; }

        /// <summary>
        /// 部分连接画刷
        /// </summary>
        public SolidColorBrush AnyConnectionBrush { get; set; }

        /// <summary>
        /// 全连接画刷
        /// </summary>
        public SolidColorBrush AllConnectionBrush { get; set; }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is ConnGroupStatus status))
                return null;

            switch (status)
            {
                case ConnGroupStatus.AllDisconnection: return this.AllDisconnectionBrush;
                case ConnGroupStatus.AnyConnection: return this.AnyConnectionBrush;
                case ConnGroupStatus.AllConnection: return this.AllConnectionBrush;
                default: return null;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
