﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Plugin;

namespace VIZ.Package.Module
{
    /// <summary>
    /// Viz配置插件生命周期
    /// </summary>
    public class VizConfigSettingPluginLifeCycle : IPluginLifeCycle
    {
        /// <summary>
        /// 插件分组
        /// </summary>
        public const string PLUGIN_GROUP = ApplicationConstants.APPLICATION_GROUP_NAME;

        /// <summary>
        /// 插件ID
        /// </summary>
        /// <remarks>
        /// 插件ID不能包含点号
        /// </remarks>
        public const string PLUGIN_ID = ModulePluginIds.VIZ_CONFIG_SETTING;

        /// <summary>
        /// 插件名称
        /// </summary>
        public const string PLUGIN_NAME = "Viz设置";

        /// <summary>
        /// 注册
        /// </summary>
        /// <returns>插件信息</returns>
        public PluginInfo Register()
        {
            PluginInfo info = new PluginInfo();
            info.Group = PLUGIN_GROUP;
            info.ID = PLUGIN_ID;
            info.Name = PLUGIN_NAME;
            info.PluginType = PluginType.Setting;
            info.ViewType = typeof(VizConfigSettingView);

            return info;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }
    }
}
