﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// GH Content 节点
    /// </summary>
    public class GH_Content_Node : IXmlSerialize
    {
        /// <summary>
        /// 地址
        /// </summary>
        public string src { get; set; }

        /// <summary>
        /// 类型
        /// <see cref="GH_Content_Type_Enums"/>
        /// </summary>
        public string type { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.src = element.GetAttributeValue<string>("src");
            this.type = element.GetAttributeValue<string>("type");
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            throw new NotSupportedException();
        }
    }
}
